<?php
session_start();
require 'db.php'; // Ensure this path is correct
require_once __DIR__.'/dompdf/autoload.inc.php';

use Dompdf\Dompdf;
use Dompdf\Options;

if (!isset($_SESSION['teacher_id'])) {
    header("Location: login.php");
    exit;
}

$teacher_id = $_SESSION['teacher_id'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $class = $_POST['class'] ?? '';
    $section = $_POST['section'] ?? '';
    $exam_name = $_POST['exam_name'] ?? '';
    $exam_year = $_POST['year'] ?? '';
    $note = $_POST['note'] ?? '';
    $school_name = $_POST['school_name'] ?? '';
    
    // Default photo upload
    $default_photo = 'default.png';
    if(isset($_FILES['default_photo']) && $_FILES['default_photo']['tmp_name']) {
        $ext = pathinfo($_FILES['default_photo']['name'], PATHINFO_EXTENSION);
        $default_photo = 'uploads/default_student_'.time().'.'.$ext;
        move_uploaded_file($_FILES['default_photo']['tmp_name'], __DIR__.'/'. $default_photo);
    }

    // Subjects
    $sub_name = $_POST['sub_name'] ?? [];
    $sub_code = $_POST['sub_code'] ?? [];
    $sub_time = $_POST['sub_time'] ?? [];
    $sub_date = $_POST['sub_date'] ?? [];

    // Create batch folder
    $folder = 'admit_files/admit_'.time();
    if(!is_dir($folder)) mkdir($folder,0777,true);

    // Insert batch info
    $stmt = $conn->prepare("INSERT INTO admit_batches (teacher_id,class,section,exam_name,exam_year,folder_path) VALUES (?,?,?,?,?,?)");
    $stmt->bind_param("isssss",$teacher_id,$class,$section,$exam_name,$exam_year,$folder);
    $stmt->execute();
    $batch_id = $stmt->insert_id;
    
    // Insert subjects
    $stmt2 = $conn->prepare("INSERT INTO admit_subjects (batch_id,subject_name,start_time) VALUES (?,?,?)");
    foreach($sub_name as $k=>$s){
        $stmt2->bind_param("iss",$batch_id,$s,$sub_time[$k]);
        $stmt2->execute();
    }

    // Fetch students of this teacher/class/section
    $res = $conn->prepare("SELECT * FROM students WHERE teacher_id=? AND class=? AND section=?");
    $res->bind_param("iss",$teacher_id,$class,$section);
    $res->execute();
    $students = $res->get_result()->fetch_all(MYSQLI_ASSOC);

    // Fetch teacher info
    $tres = $conn->prepare("SELECT * FROM teachers WHERE id=?");
    $tres->bind_param("i",$teacher_id);
    $tres->execute();
    $teacher = $tres->get_result()->fetch_assoc();
    $school_name = $school_name ?: $teacher['institute_name'];
    $school_logo = $teacher['logo'] ? 'https://teacher.sm10x.xyz/uploads/'.$teacher['logo'] : '';

    $options = new Options();
    $options->set('isRemoteEnabled', true);
    $dompdf = new Dompdf($options);

    $html = '';
    foreach($students as $stu){
        $photo = $default_photo;
        // Build individual admit card HTML
        $html .= '
        <div style="width:48%; display:inline-block; margin:1%; padding:20px; border-radius:12px; box-shadow:0 4px 12px rgba(0,0,0,0.15); background: linear-gradient(to bottom, #ffffff, #f0f4ff); font-family: Arial, sans-serif; color:#1a1a1a; page-break-inside: avoid;">
          <div style="text-align:center; margin-bottom:10px;">
            '.($school_logo ? '<img src="'.$school_logo.'" style="max-height:50px;"><br>' : '').'
            <h2 style="margin:5px 0; color:#0077cc;">'.$school_name.'</h2>
            <p style="font-size:14px; color:#555;">'.$exam_name.' ('.$exam_year.')</p>
          </div>
          <hr style="border-color:#0077cc; margin-bottom:10px;">
          
          <div style="display:flex; justify-content:space-between; align-items:center;">
            <div>
              <p><strong>Name:</strong> '.$stu['name'].'</p>
              <p><strong>Class:</strong> '.$stu['class'].'</p>
              <p><strong>Section:</strong> '.$stu['section'].'</p>
              <p><strong>Roll:</strong> '.$stu['roll'].'</p>
            </div>
            <div>
              <img src="'.$photo.'" style="width:80px; height:80px; border-radius:50%; border:2px solid #0077cc;">
            </div>
          </div>

          <div style="margin-top:12px;">
            <table style="width:100%; border-collapse:collapse; font-size:13px;">
              <thead>
                <tr style="background:#0077cc; color:#fff;">
                  <th style="padding:5px;">Subject</th>
                  <th style="padding:5px;">Start Time</th>
                </tr>
              </thead>
              <tbody>';
        foreach($sub_name as $k=>$s){
            $html .= '<tr style="border-bottom:1px solid #ddd;">
                        <td style="padding:4px;">'.$s.'</td>
                        <td style="padding:4px;">'.($sub_time[$k]??'-').'</td>
                      </tr>';
        }
        $html .= '</tbody>
            </table>
          </div>

          <div style="margin-top:10px; font-size:12px; color:#555;">'.$note.'</div>
          <div style="position:absolute; top:50%; left:50%; font-size:60px; color:rgba(0,0,0,0.05); transform:translate(-50%,-50%) rotate(-45deg); z-index:-1;">CONFIDENTIAL</div>
        </div>';
    }

    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();

    // Save PDF to server
    $output = $dompdf->output();
    $pdf_file = $folder.'/admit_cards.pdf';
    file_put_contents($pdf_file, $output);

    // Create ZIP
    $zip = new ZipArchive();
    $zip_file = $folder.'.zip';
    if($zip->open($zip_file, ZipArchive::CREATE) === true){
        $zip->addFile($pdf_file, 'admit_cards.pdf');
        $zip->close();
    }

    // Redirect to download
    header('Content-Type: application/zip');
    header('Content-Disposition: attachment; filename="'.basename($zip_file).'"');
    readfile($zip_file);
    exit;
}
