<?php
// admit_form.php
session_start();
require 'db.php';

// Teacher login check
if(!isset($_SESSION['teacher_id'])){
    header("Location: login.php");
    exit;
}
$teacher_id = $_SESSION['teacher_id'];

// fetch distinct classes for this teacher
$classes = [];
$res = $conn->query("SELECT DISTINCT class FROM students WHERE teacher_id=$teacher_id ORDER BY class ASC");
while($row = $res->fetch_assoc()) $classes[] = $row['class'];
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8"/>
<meta name="viewport" content="width=device-width,initial-scale=1"/>
<title>Generate Admit Cards</title>
<script src="https://cdn.tailwindcss.com"></script>
<style>
  .glass {
    background: rgba(255,255,255,0.05);
    backdrop-filter: blur(8px);
    border: 1px solid rgba(255,255,255,0.1);
  }
  body {
    background: linear-gradient(135deg,#0a0f2c,#02060a);
  }
</style>
</head>
<body class="text-white antialiased">
<div class="max-w-5xl mx-auto p-8">
  <h1 class="text-3xl font-bold mb-4 text-yellow-400">Admit Card Generator</h1>
  <p class="text-slate-400 mb-6">Generate professional admit cards — 2 per A4, ZIP download. Only your students.</p>

  <form action="generate_admit.php" method="post" enctype="multipart/form-data" class="glass p-6 rounded-3xl space-y-6">
    <input type="hidden" name="teacher_id" value="<?=$teacher_id?>">

    <!-- Class & Section -->
    <div class="grid md:grid-cols-2 gap-4">
      <div>
        <label class="block text-sm text-slate-300 mb-1">Class</label>
        <select id="classSelect" name="class" required class="w-full p-2 rounded bg-transparent border border-slate-600">
          <option value="">Select class</option>
          <?php foreach($classes as $c): ?>
            <option value="<?=htmlspecialchars($c)?>"><?=htmlspecialchars($c)?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div>
        <label class="block text-sm text-slate-300 mb-1">Section</label>
        <select id="sectionSelect" name="section" required class="w-full p-2 rounded bg-transparent border border-slate-600">
          <option value="">Select section</option>
        </select>
      </div>
    </div>

    <!-- Exam Details -->
    <div class="grid md:grid-cols-2 gap-4">
      <div>
        <label class="block text-sm text-slate-300 mb-1">Exam Name</label>
        <input type="text" name="exam_name" required placeholder="Half Yearly Examination" class="w-full p-2 rounded bg-transparent border border-slate-600"/>
      </div>
      <div>
        <label class="block text-sm text-slate-300 mb-1">Exam Year</label>
        <input type="text" name="year" required placeholder="2025" class="w-full p-2 rounded bg-transparent border border-slate-600"/>
      </div>
    </div>

    <!-- School + Default Photo -->
    <div class="grid md:grid-cols-2 gap-4">
      <div>
        <label class="block text-sm text-slate-300 mb-1">School Name (optional)</label>
        <input name="school_name" placeholder="Will fallback to your institute" class="w-full p-2 rounded bg-transparent border border-slate-600"/>
      </div>
      <div>
        <label class="block text-sm text-slate-300 mb-1">Default Student Photo (optional)</label>
        <input type="file" name="default_photo" accept="image/*" class="w-full"/>
      </div>
    </div>

    <!-- Subjects -->
    <div>
      <label class="block text-sm text-slate-300 mb-2 flex justify-between items-center">
        Subjects & Schedule
        <button type="button" onclick="addRow()" class="bg-yellow-400 text-black px-3 py-1 rounded">+ Add</button>
      </label>
      <div id="subjectsWrap" class="space-y-2 max-h-60 overflow-auto p-2 border border-slate-600 rounded">
        <div class="flex gap-2">
          <input name="sub_name[]" placeholder="Subject" required class="flex-1 p-2 rounded bg-transparent border border-slate-600"/>
          <input name="sub_code[]" placeholder="Code" class="w-24 p-2 rounded bg-transparent border border-slate-600"/>
          <input name="sub_date[]" placeholder="YYYY-MM-DD" class="w-36 p-2 rounded bg-transparent border border-slate-600"/>
          <input name="sub_time[]" placeholder="09:00 AM" class="w-28 p-2 rounded bg-transparent border border-slate-600"/>
          <button type="button" onclick="this.parentNode.remove()" class="px-3 rounded bg-red-600">✕</button>
        </div>
      </div>
    </div>

    <!-- Additional Note -->
    <div>
      <label class="block text-sm text-slate-300 mb-1">Additional Note</label>
      <textarea name="note" rows="2" class="w-full p-2 rounded bg-transparent border border-slate-600"></textarea>
    </div>

    <!-- Submit -->
    <div class="flex justify-end gap-3">
      <a href="view_admits.php?folder=generated" class="px-4 py-2 border border-slate-600 rounded text-slate-300">View Generated</a>
      <button type="submit" class="px-6 py-2 rounded bg-yellow-400 text-black font-semibold hover:bg-yellow-300">Generate & Download ZIP</button>
    </div>
  </form>
</div>

<script>
async function loadSections(cls){
  const sel = document.getElementById('sectionSelect');
  sel.innerHTML = '<option>Loading...</option>';
  try {
    const res = await fetch('fetch_sections.php?class=' + encodeURIComponent(cls));
    const json = await res.json();
    sel.innerHTML = '<option value="">Select section</option>';
    json.forEach(s => {
      const o = document.createElement('option'); o.value = s; o.textContent = s;
      sel.appendChild(o);
    });
  } catch(err) { sel.innerHTML = '<option value="">Error</option>'; }
}

document.getElementById('classSelect').addEventListener('change', function(){ loadSections(this.value); });

function addRow(){
  const wrap = document.getElementById('subjectsWrap');
  const div = document.createElement('div');
  div.className = 'flex gap-2';
  div.innerHTML = `<input name="sub_name[]" placeholder="Subject" required class="flex-1 p-2 rounded bg-transparent border border-slate-600"/>
  <input name="sub_code[]" placeholder="Code" class="w-24 p-2 rounded bg-transparent border border-slate-600"/>
  <input name="sub_date[]" placeholder="YYYY-MM-DD" class="w-36 p-2 rounded bg-transparent border border-slate-600"/>
  <input name="sub_time[]" placeholder="09:00 AM" class="w-28 p-2 rounded bg-transparent border border-slate-600"/>
  <button type="button" onclick="this.parentNode.remove()" class="px-3 rounded bg-red-600">✕</button>`;
  wrap.appendChild(div);
}
</script>
</body>
</html>
