<?php
// view_admits.php
session_start();
require 'db.php';

if(!isset($_SESSION['teacher_id'])){
    die("Access denied.");
}
$teacher_id = $_SESSION['teacher_id'];

// Handle filter
$class_filter = $_GET['class'] ?? '';
$section_filter = $_GET['section'] ?? '';

$where = "WHERE teacher_id=$teacher_id";
if($class_filter) $where .= " AND class='".$conn->real_escape_string($class_filter)."'";
if($section_filter) $where .= " AND section='".$conn->real_escape_string($section_filter)."'";

// Fetch distinct classes & sections for filter dropdown
$classes = [];
$res = $conn->query("SELECT DISTINCT class FROM admit_batches WHERE teacher_id=$teacher_id");
while($r=$res->fetch_assoc()) $classes[]=$r['class'];

$sections = [];
$res = $conn->query("SELECT DISTINCT section FROM admit_batches WHERE teacher_id=$teacher_id");
while($r=$res->fetch_assoc()) $sections[]=$r['section'];

// Fetch batches
$batches = [];
$res = $conn->query("SELECT * FROM admit_batches $where ORDER BY created_at DESC");
while($r=$res->fetch_assoc()) $batches[]=$r;

?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>View Generated Admits</title>
<script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gradient-to-b from-[#071029] to-[#02060a] text-white p-6">
  <div class="max-w-6xl mx-auto">
    <h1 class="text-2xl font-bold mb-4">Generated Admit Cards</h1>

    <!-- Filter -->
    <form class="flex gap-4 mb-6" method="get">
      <select name="class" class="p-2 rounded bg-transparent border border-slate-700">
        <option value="">All Classes</option>
        <?php foreach($classes as $c): ?>
          <option value="<?=htmlspecialchars($c)?>" <?=($c==$class_filter?'selected':'')?>><?=htmlspecialchars($c)?></option>
        <?php endforeach; ?>
      </select>
      <select name="section" class="p-2 rounded bg-transparent border border-slate-700">
        <option value="">All Sections</option>
        <?php foreach($sections as $s): ?>
          <option value="<?=htmlspecialchars($s)?>" <?=($s==$section_filter?'selected':'')?>><?=htmlspecialchars($s)?></option>
        <?php endforeach; ?>
      </select>
      <button type="submit" class="px-4 py-2 bg-yellow-400 text-black rounded">Filter</button>
    </form>

    <!-- Admit table -->
    <div class="overflow-x-auto">
      <table class="w-full table-auto border-collapse border border-slate-700">
        <thead>
          <tr class="bg-slate-800">
            <th class="border border-slate-700 px-2 py-1">#</th>
            <th class="border border-slate-700 px-2 py-1">Class</th>
            <th class="border border-slate-700 px-2 py-1">Section</th>
            <th class="border border-slate-700 px-2 py-1">Exam</th>
            <th class="border border-slate-700 px-2 py-1">Year</th>
            <th class="border border-slate-700 px-2 py-1">Created At</th>
            <th class="border border-slate-700 px-2 py-1">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php if(count($batches)==0): ?>
            <tr>
              <td colspan="7" class="text-center p-2">No records found.</td>
            </tr>
          <?php else: ?>
            <?php foreach($batches as $i=>$b): ?>
              <tr class="<?=($i%2==0?'bg-slate-900':'bg-slate-800')?>">
                <td class="border border-slate-700 px-2 py-1"><?=($i+1)?></td>
                <td class="border border-slate-700 px-2 py-1"><?=htmlspecialchars($b['class'])?></td>
                <td class="border border-slate-700 px-2 py-1"><?=htmlspecialchars($b['section'])?></td>
                <td class="border border-slate-700 px-2 py-1"><?=htmlspecialchars($b['exam_name'])?></td>
                <td class="border border-slate-700 px-2 py-1"><?=htmlspecialchars($b['exam_year'])?></td>
                <td class="border border-slate-700 px-2 py-1"><?=htmlspecialchars($b['created_at'])?></td>
                <td class="border border-slate-700 px-2 py-1 flex gap-2">
                  <?php
                    $pdfPath = 'generated/'.$b['folder_path'].'.pdf';
                    $zipPath = 'generated/'.$b['folder_path'].'.zip';
                  ?>
                  <a href="<?=htmlspecialchars($pdfPath)?>" target="_blank" class="px-2 py-1 bg-blue-600 rounded">PDF</a>
                  <a href="<?=htmlspecialchars($zipPath)?>" target="_blank" class="px-2 py-1 bg-green-600 rounded">ZIP</a>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</body>
</html>
