<?php
// attendance-report.php
session_start();
include "config.php";

if (!isset($_SESSION['teacher_email'])) {
  header("Location: login.php");
  exit;
}

$email = $_SESSION['teacher_email'];
$stmt = $conn->prepare("SELECT id FROM teachers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$res = $stmt->get_result();
$teacher = $res->fetch_assoc();
$teacher_id = $teacher['id'];

$filter = $_GET['filter'] ?? 'daily';
$class_filter = $_GET['class'] ?? '';
$name_filter = $_GET['name'] ?? '';
$roll_filter = $_GET['roll'] ?? '';

$date_sql = "";
if ($filter === 'weekly') {
  $date_sql = "AND a.date >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)";
} elseif ($filter === 'monthly') {
  $date_sql = "AND a.date >= DATE_SUB(CURDATE(), INTERVAL 1 MONTH)";
} else {
  $date_sql = "AND a.date = CURDATE()";
}

// Update attendance (edit option)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['student_id'], $_POST['status'], $_POST['date'])) {
  $sid = intval($_POST['student_id']);
  $status = $_POST['status'] === 'absent' ? 'absent' : 'present';
  $date = $_POST['date'];

  // Check if record exists
  $chk = $conn->query("SELECT id FROM attendance WHERE student_id=$sid AND date='$date'");
  if ($chk->num_rows > 0) {
    $conn->query("UPDATE attendance SET status='$status' WHERE student_id=$sid AND date='$date'");
  } else {
    $conn->query("INSERT INTO attendance (student_id, date, status, marked_by) VALUES ($sid, '$date', '$status', $teacher_id)");
  }
}

// Base student query
$sql = "SELECT s.id, s.name, s.class, s.roll, s.parent_number
        FROM students s
        WHERE s.teacher_id = $teacher_id";

// Filters
if ($class_filter !== '') {
  $class_filter = $conn->real_escape_string($class_filter);
  $sql .= " AND s.class LIKE '%$class_filter%'";
}
if ($name_filter !== '') {
  $name_filter = $conn->real_escape_string($name_filter);
  $sql .= " AND s.name LIKE '%$name_filter%'";
}
if ($roll_filter !== '') {
  $roll_filter = $conn->real_escape_string($roll_filter);
  $sql .= " AND s.roll LIKE '%$roll_filter%'";
}
$sql .= " ORDER BY s.class ASC, s.roll ASC";
$students = $conn->query($sql);

// Attendance lookup
$att_sql = "SELECT student_id, date, status FROM attendance a WHERE a.marked_by=$teacher_id $date_sql";
$attendance = [];
$res = $conn->query($att_sql);
while ($row = $res->fetch_assoc()) {
  $attendance[$row['student_id']][$row['date']] = $row['status'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Attendance Report</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    function copyNumber(number) {
      navigator.clipboard.writeText(number).then(() => {
        alert("Copied: " + number);
      });
    }
  </script>
</head>
<body class="bg-slate-900 text-white p-6">
  <div class="max-w-6xl mx-auto">

    <!-- Header -->
    <div class="flex items-center justify-between mb-6">
      <h1 class="text-2xl font-bold text-yellow-400">📅 Attendance Report (<?= htmlspecialchars($filter) ?>)</h1>
      <a href="dashboard.php" class="text-yellow-300 hover:underline">⬅️ Back to Dashboard</a>
    </div>

    <!-- Filter Links -->
    <div class="mb-4 space-x-2">
      <a href="?filter=daily" class="px-3 py-1 rounded bg-sky-600 hover:bg-sky-500">Daily</a>
      <a href="?filter=weekly" class="px-3 py-1 rounded bg-sky-600 hover:bg-sky-500">Weekly</a>
      <a href="?filter=monthly" class="px-3 py-1 rounded bg-sky-600 hover:bg-sky-500">Monthly</a>
    </div>

    <!-- Search Form -->
    <form method="GET" class="mb-4 flex flex-wrap gap-2">
      <input type="hidden" name="filter" value="<?= htmlspecialchars($filter) ?>">
      <input type="text" name="class" value="<?= htmlspecialchars($class_filter) ?>" placeholder="Class/Section" class="px-3 py-2 bg-slate-800 rounded">
      <input type="text" name="roll" value="<?= htmlspecialchars($roll_filter) ?>" placeholder="Roll" class="px-3 py-2 bg-slate-800 rounded">
      <input type="text" name="name" value="<?= htmlspecialchars($name_filter) ?>" placeholder="Name" class="px-3 py-2 bg-slate-800 rounded">
      <button type="submit" class="px-4 py-2 bg-yellow-400 text-black rounded hover:bg-yellow-300">🔍 Search</button>
      <a href="attendance-report.php?filter=<?= htmlspecialchars($filter) ?>" class="text-sky-300 underline mt-2">Reset</a>
    </form>

    <!-- Report Table -->
    <table class="w-full table-auto border border-slate-700 text-sm">
      <thead class="bg-slate-800">
        <tr>
          <th class="p-2">Name</th>
          <th class="p-2">Class/Section</th>
          <th class="p-2">Roll</th>
          <th class="p-2">Parent Number</th>
          <th class="p-2">Date</th>
          <th class="p-2">Status</th>
          <th class="p-2">Edit</th>
        </tr>
      </thead>
      <tbody>
        <?php while($s = $students->fetch_assoc()): 
          $status = "present"; // default
          $date = date("Y-m-d");
          if (isset($attendance[$s['id']][$date])) {
            $status = $attendance[$s['id']][$date];
          }
        ?>
        <tr class="border-b border-slate-700">
          <td class="p-2"><?= htmlspecialchars($s['name']) ?></td>
          <td class="p-2 text-center"><?= htmlspecialchars($s['class']) ?></td>
          <td class="p-2 text-center"><?= htmlspecialchars($s['roll']) ?></td>
          <td class="p-2 text-center">
            <button type="button" onclick="copyNumber('<?= $s['parent_number'] ?>')" class="text-sky-400 hover:underline">
              <?= htmlspecialchars($s['parent_number']) ?>
            </button>
          </td>
          <td class="p-2 text-center"><?= $date ?></td>
          <td class="p-2 text-center <?= $status === 'present' ? 'text-green-400' : 'text-red-400' ?>">
            <?= ucfirst($status) ?>
          </td>
          <td class="p-2 text-center">
            <form method="POST" class="inline">
              <input type="hidden" name="student_id" value="<?= $s['id'] ?>">
              <input type="hidden" name="date" value="<?= $date ?>">
              <input type="hidden" name="status" value="<?= $status === 'present' ? 'absent' : 'present' ?>">
              <button type="submit" class="px-2 py-1 rounded bg-sky-600 hover:bg-sky-500 text-xs">
                Mark <?= $status === 'present' ? 'Absent' : 'Present' ?>
              </button>
            </form>
          </td>
        </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</body>
</html
