<?php
session_start();
include "config.php";

if (!isset($_SESSION['teacher_email'])) {
  header("Location: login.php");
  exit;
}

$email = $_SESSION['teacher_email'];
$stmt = $conn->prepare("SELECT * FROM teachers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();
$teacher = $result->fetch_assoc();
$teacher_id = $teacher['id'];
$api_key = $teacher['api_key'];

$response = "";

// Handle POST (mark absents)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['absents'])) {
  $absents = $_POST['absents'];
  $today = date("Y-m-d");
  foreach ($absents as $sid) {
    $sid = intval($sid);

    // Insert attendance
    $conn->query("INSERT INTO attendance (student_id, date, status, marked_by) VALUES ($sid, '$today', 'absent', $teacher_id)");

    // Send SMS
    $s = $conn->query("SELECT name, parent_number FROM students WHERE id = $sid")->fetch_assoc();
    $sms = "Dear guardian, your child {$s['name']} is absent today.";
    if ($api_key) {
      $data = ["api" => $api_key, "number" => $s['parent_number'], "message" => $sms];
      $ch = curl_init("https://panel.sm10x.xyz/sent_sms_post.php");
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_POST, true);
      curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
      curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
      curl_exec($ch);
      curl_close($ch);

      $conn->query("INSERT INTO sms_logs (teacher_id, student_id, number, message, status) VALUES ($teacher_id, $sid, '{$s['parent_number']}', '$sms', 'sent')");
    }
  }
  $response = "✅ Absent marked and SMS sent.";
}

// Filter logic
$class_filter = $_GET['class'] ?? '';
$section_filter = $_GET['section'] ?? '';
$name_filter = $_GET['name'] ?? '';

$sql = "SELECT * FROM students WHERE teacher_id = $teacher_id";
if ($class_filter !== '') {
  $class_filter = $conn->real_escape_string($class_filter);
  $sql .= " AND class LIKE '%$class_filter%'";
}
if ($section_filter !== '') {
  $section_filter = $conn->real_escape_string($section_filter);
  $sql .= " AND section LIKE '%$section_filter%'";
}
if ($name_filter !== '') {
  $name_filter = $conn->real_escape_string($name_filter);
  $sql .= " AND name LIKE '%$name_filter%'";
}
$sql .= " ORDER BY class ASC, section ASC, roll ASC";

$students = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Mark Attendance | SM Teacher</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 text-white min-h-screen">
  <div class="max-w-5xl mx-auto p-6">
    <div class="flex items-center justify-between mb-6">
      <h1 class="text-2xl font-bold text-yellow-400">🕓 Mark Absents with SMS</h1>
      <a href="dashboard.php" class="text-sm text-sky-400 hover:underline">← Back to Dashboard</a>
    </div>

    <?php if ($response): ?>
      <div class="mb-4 p-3 rounded text-sm bg-green-600"><?= htmlspecialchars($response) ?></div>
    <?php endif; ?>

    <!-- Filter Form -->
    <form method="GET" class="mb-4 flex flex-wrap gap-3">
      <input type="text" name="class" value="<?= htmlspecialchars($class_filter) ?>" placeholder="Search by Class..." class="px-3 py-2 bg-slate-700 rounded">
      <input type="text" name="section" value="<?= htmlspecialchars($section_filter) ?>" placeholder="Search by Section..." class="px-3 py-2 bg-slate-700 rounded">
      <input type="text" name="name" value="<?= htmlspecialchars($name_filter) ?>" placeholder="Search by Name..." class="px-3 py-2 bg-slate-700 rounded">
      <button type="submit" class="bg-yellow-400 text-black px-4 py-2 rounded hover:bg-yellow-300">🔍 Filter</button>
      <a href="attendance.php" class="text-sky-300 underline text-sm mt-3">Reset</a>
    </form>

    <!-- Attendance Form -->
    <form method="POST" class="bg-slate-800 p-5 rounded-xl">
      <p class="mb-3">Select absent students for today (<?= date('d M Y') ?>):</p>
      <div class="grid grid-cols-1 md:grid-cols-2 gap-2 max-h-72 overflow-y-auto">
        <?php while($row = $students->fetch_assoc()): ?>
          <label class="flex items-center space-x-2">
            <input type="checkbox" name="absents[]" value="<?= $row['id'] ?>" class="accent-yellow-400">
            <span><?= htmlspecialchars($row['name']) ?> (Class: <?= htmlspecialchars($row['class']) ?>, Section: <?= htmlspecialchars($row['section']) ?>, Roll: <?= htmlspecialchars($row['roll']) ?>)</span>
          </label>
        <?php endwhile; ?>
      </div>
      <button type="submit" class="mt-6 w-full bg-yellow-400 text-black font-semibold py-3 rounded hover:bg-yellow-300">✅ Submit Absent</button>
    </form>
  </div>
</body>
</html>
