<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
include "../config.php";

// Load PHPMailer
require "PHPMailer/Exception.php";
require "PHPMailer/PHPMailer.php";
require "PHPMailer/SMTP.php";

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Handle search
$search = $_GET['search'] ?? '';
if ($search) {
  $searchTerm = "%$search%";
  $stmt = $conn->prepare("SELECT * FROM teachers WHERE name LIKE ? OR email LIKE ? OR phone LIKE ?");
  $stmt->bind_param("sss", $searchTerm, $searchTerm, $searchTerm);
} else {
  $stmt = $conn->prepare("SELECT * FROM teachers");
}
$stmt->execute();
$result = $stmt->get_result();

// Handle reset link request
$success = $error = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['teacher_id'])) {
  $id = intval($_POST['teacher_id']);
  $token = bin2hex(random_bytes(32));
  $expires = date("Y-m-d H:i:s", strtotime("+1 hour"));

  $update = $conn->prepare("UPDATE teachers SET reset_token = ?, token_expires = ? WHERE id = ?");
  $update->bind_param("ssi", $token, $expires, $id);
  if ($update->execute()) {
    $res = $conn->query("SELECT email FROM teachers WHERE id = $id");
    $email = $res->fetch_assoc()['email'];

    $mail = new PHPMailer(true);
    try {
      $mail->isSMTP();
      $mail->Host = 'mail.sm10x.xyz';
      $mail->SMTPAuth = true;
      $mail->Username = 'support_teacher@sm10x.xyz';
      $mail->Password = 'support_teacher@sm10x.xyz'; // ✅ Replace with real SMTP password
      $mail->SMTPSecure = 'ssl';
      $mail->Port = 465;

      $mail->setFrom('support_teacher@sm10x.xyz', 'SM Teacher Support');
      $mail->addAddress($email);

      $resetLink = "https://teacher.sm10x.xyz/reset-password-link.php?token=$token";
      $mail->Subject = "🔐 Reset Your Password - SM Teacher";
      $mail->Body = "Hello,\n\nClick the link below to reset your password:\n\n$resetLink\n\nNote: This link will expire in 1 hour.\n\nThanks,\nSM Teacher";

      $mail->send();
      $success = "✅ Reset link sent to $email";
    } catch (Exception $e) {
      $error = "❌ Email send failed: " . $mail->ErrorInfo;
    }
  } else {
    $error = "❌ Failed to update reset token.";
  }
}
?>

<!DOCTYPE html>
<html>
<head>
  <title>Reset Teacher Password</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 text-white p-6">
    <div class="w-64 bg-slate-800 p-6 space-y-4">
        <h1 class="text-2xl text-yellow-400 font-bold mb-6">🔐 Reset Teacher Password</h1>
    <nav class="space-y-2">
      <a href="dashboard.php" class="block text-white hover:text-yellow-400">🏠 Dashboard</a>
      <a href="teachers.php" class="block text-white hover:text-yellow-400">👩‍🏫 Teachers</a>
      <a href="students.php" class="block text-yellow-400 font-bold">📚 Students</a>
      <a href="reset-password.php" class="block text-white hover:text-yellow-400">🔑 Reset Password</a>
      <a href="logout.php" class="block text-red-400 hover:underline">🚪 Logout</a>
    </nav>
  </div>

    <form method="GET" class="mb-4">
      <input type="text" name="search" placeholder="Search by name/email/phone..." value="<?= htmlspecialchars($_GET['search'] ?? '') ?>" class="p-2 rounded bg-slate-800 w-80" />
      <button type="submit" class="bg-yellow-400 text-black font-semibold px-4 py-2 rounded">🔍 Search</button>
    </form>

    <?php if ($success): ?>
      <div class="bg-green-600 text-white p-3 rounded mb-4"><?= $success ?></div>
    <?php elseif ($error): ?>
      <div class="bg-red-600 text-white p-3 rounded mb-4"><?= $error ?></div>
    <?php endif; ?>

    <table class="w-full bg-slate-800 rounded text-sm">
      <thead class="bg-slate-700 text-yellow-300">
        <tr>
          <th class="py-2 px-3 text-left">👩‍🏫 Name</th>
          <th class="py-2 px-3 text-left">📧 Email</th>
          <th class="py-2 px-3 text-left">📱 Phone</th>
          <th class="py-2 px-3 text-left">🛠️ Action</th>
        </tr>
      </thead>
      <tbody>
        <?php while($t = $result->fetch_assoc()): ?>
        <tr class="border-b border-slate-600">
          <td class="py-2 px-3"><?= htmlspecialchars($t['name']) ?></td>
          <td class="py-2 px-3"><?= htmlspecialchars($t['email']) ?></td>
          <td class="py-2 px-3"><?= htmlspecialchars($t['phone']) ?></td>
          <td class="py-2 px-3">
            <form method="POST" class="inline">
              <input type="hidden" name="teacher_id" value="<?= $t['id'] ?>">
              <button type="submit" class="bg-yellow-400 text-black px-3 py-1 rounded text-xs font-bold hover:bg-yellow-300">Send Reset Link</button>
            </form>
          </td>
        </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</body>
</html>
