<?php
session_start();
include "config.php";

if (!isset($_SESSION['teacher_email'])) {
  header("Location: login.php");
  exit;
}

$email = $_SESSION['teacher_email'];
$stmt = $conn->prepare("SELECT * FROM teachers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$teacher = $stmt->get_result()->fetch_assoc();

$success = "";
$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = $_POST['name'] ?? '';
  $phone = $_POST['phone'] ?? '';
  $institute = $_POST['institute_name'] ?? '';
  $api_key = $_POST['api_key'] ?? '';
  $logoFile = $_FILES['logo']['name'] ?? '';
  $logoName = $teacher['logo'];

  // Handle logo upload
  if (!empty($logoFile)) {
    $ext = strtolower(pathinfo($logoFile, PATHINFO_EXTENSION));
    if (in_array($ext, ['jpg', 'jpeg', 'png', 'webp'])) {
      $logoName = "logo_" . time() . "." . $ext;
      move_uploaded_file($_FILES['logo']['tmp_name'], "uploads/" . $logoName);
    } else {
      $error = "❌ Only JPG, PNG, or WEBP images allowed.";
    }
  }

  if (!$error) {
    $stmt = $conn->prepare("UPDATE teachers SET name=?, phone=?, institute_name=?, api_key=?, logo=? WHERE email=?");
    $stmt->bind_param("ssssss", $name, $phone, $institute, $api_key, $logoName, $email);
    $stmt->execute();
    $success = "✅ Profile updated successfully.";
    $teacher['name'] = $name;
    $teacher['phone'] = $phone;
    $teacher['institute_name'] = $institute;
    $teacher['api_key'] = $api_key;
    $teacher['logo'] = $logoName;
  }
}
?>

<!DOCTYPE html>
<html>
<head>
  <title>Update Profile</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 text-white p-6">
  <div class="max-w-2xl mx-auto">
    <h1 class="text-2xl font-bold text-yellow-400 mb-6">👤 Teacher Profile</h1>

    <?php if ($success): ?>
      <div class="bg-green-600 p-3 rounded mb-4"><?= $success ?></div>
    <?php elseif ($error): ?>
      <div class="bg-red-600 p-3 rounded mb-4"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST" enctype="multipart/form-data" class="space-y-4">
      <div>
        <label class="block mb-1 text-sm">Name:</label>
        <input type="text" name="name" value="<?= htmlspecialchars($teacher['name']) ?>" class="w-full p-2 rounded bg-slate-800" required>
      </div>
      <div>
        <label class="block mb-1 text-sm">Phone:</label>
        <input type="text" name="phone" value="<?= htmlspecialchars($teacher['phone']) ?>" class="w-full p-2 rounded bg-slate-800" required>
      </div>
      <div>
        <label class="block mb-1 text-sm">Institute Name:</label>
        <input type="text" name="institute_name" value="<?= htmlspecialchars($teacher['institute_name']) ?>" class="w-full p-2 rounded bg-slate-800" required>
      </div>
      <div>
        <label class="block mb-1 text-sm">SM10x API Key:</label>
        <input type="text" name="api_key" value="<?= htmlspecialchars($teacher['api_key']) ?>" class="w-full p-2 rounded bg-slate-800" required>
      </div>
      <div>
        <label class="block mb-1 text-sm">School Logo:</label>
        <input type="file" name="logo" accept=".jpg,.jpeg,.png,.webp" class="w-full text-sm bg-slate-800 p-2 rounded">
        <?php if (!empty($teacher['logo'])): ?>
          <div class="mt-3">
            <p class="text-sm text-slate-400 mb-1">Current Logo:</p>
            <img src="uploads/<?= htmlspecialchars($teacher['logo']) ?>" class="w-28 rounded border border-slate-600 shadow" />
          </div>
        <?php endif; ?>
      </div>
      <button type="submit" class="bg-yellow-400 text-black px-4 py-2 rounded font-bold hover:bg-yellow-300">💾 Save Changes</button>
    </form>

    <div class="mt-6">
      <a href="dashboard.php" class="text-yellow-300 hover:underline">⬅️ Back to Dashboard</a>
    </div>
  </div>
</body>
</html>
