<?php
include "config.php";

$token = $_GET['token'] ?? '';
if (!$token) {
  die("Invalid or missing token.");
}

$stmt = $conn->prepare("SELECT * FROM teachers WHERE reset_token = ?");
$stmt->bind_param("s", $token);
$stmt->execute();
$result = $stmt->get_result();
$teacher = $result->fetch_assoc();

if (!$teacher) {
  die("Token expired or invalid.");
}


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $new_pass = password_hash($_POST['password'], PASSWORD_DEFAULT);
  $conn->query("UPDATE teachers SET password = '$new_pass', reset_token = NULL WHERE id = {$teacher['id']}");
  echo "<script>alert('✅ Password reset successfully!'); window.location='login.php';</script>";
}
?>

<!DOCTYPE html>
<html>
<head>
  <title>Reset Password</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 text-white p-6 flex items-center justify-center min-h-screen">
  <form method="POST" class="bg-slate-800 p-6 rounded w-full max-w-md space-y-4">
    <h2 class="text-xl font-bold text-yellow-400 mb-2">🔐 Set New Password</h2>
    <input type="password" name="password" placeholder="New Password" required class="w-full p-2 bg-slate-700 rounded">
    <button type="submit" class="w-full bg-yellow-400 text-black font-bold py-2 rounded hover:bg-yellow-300">✅ Update Password</button>
  </form>
</body>
</html>
