<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include "config.php";
require_once 'dompdf/autoload.inc.php';
use Dompdf\Dompdf;
use Dompdf\Options;

if (!isset($_SESSION['teacher_email']) || !isset($_POST['student_id'])) {
    header("Location: result-make.php");
    exit;
}

// Teacher info
$teacher_email = $_SESSION['teacher_email'];
$teacher_stmt = $conn->prepare("SELECT id, name, logo, institute_name FROM teachers WHERE email = ?");
$teacher_stmt->bind_param("s", $teacher_email);
$teacher_stmt->execute();
$teacher_data = $teacher_stmt->get_result()->fetch_assoc();

$teacher_id = $teacher_data['id'];
$teacher_logo = $teacher_data['logo'];
$institute_name = $teacher_data['institute_name'];

// Student info
$student_id = intval($_POST['student_id']);
$student = $conn->query("SELECT * FROM students WHERE id = $student_id")->fetch_assoc();

// Subjects and marks
$subjects = $_POST['subject'] ?? [];
$marks = $_POST['mark'] ?? [];

$total_marks = 0;
$total_gpa = 0;
$fail = false;
$subject_rows = '';

// GPA Calculation Function
function calculate_gpa($mark) {
    if ($mark >= 80) return 5.00;
    if ($mark >= 70) return 4.00;
    if ($mark >= 60) return 3.50;
    if ($mark >= 50) return 3.00;
    if ($mark >= 40) return 2.00;
    if ($mark >= 33) return 1.00;
    return 0.00;
}

// Build subject rows
foreach ($subjects as $i => $sub) {
    $mark = floatval($marks[$i]);
    $gpa = calculate_gpa($mark);
    if ($gpa == 0.00) $fail = true;

    $subject_rows .= "
    <tr>
        <td style='border:1px solid #ccc;padding:6px;border-radius:4px;'>{$sub}</td>
        <td style='border:1px solid #ccc;padding:6px;border-radius:4px;text-align:center;'>{$mark}</td>
        <td style='border:1px solid #ccc;padding:6px;border-radius:4px;text-align:center;'>".number_format($gpa,2)."</td>
    </tr>";

    $total_marks += $mark;
    $total_gpa += $gpa;
}

$avg_gpa = count($subjects) > 0 ? $total_gpa / count($subjects) : 0;
$final_status_text = $fail ? "Fail" : "Pass";
$final_status_html = $fail ? "<span style='background:#fff1f2;color:#b91c1c;border:1px solid #fecaca;padding:3px 8px;border-radius:10px;font-weight:bold;'>❌ Fail</span>" : "<span style='background:#e6ffef;color:#047857;border:1px solid #bbf7d0;padding:3px 8px;border-radius:10px;font-weight:bold;'>✅ Pass</span>";

// Logo HTML
$logo_html = '';
if ($teacher_logo && file_exists("uploads/$teacher_logo")) {
    $logo_url = "https://teacher.sm10x.xyz/uploads/$teacher_logo";
    $logo_html = "<img src='$logo_url' style='height:80px;margin-bottom:10px;'/>";
}

// HTML for PDF
$html = '
<html>
<head>
<meta charset="UTF-8">
<style>
body { font-family:"DejaVu Sans", sans-serif; color:#222; margin:0; padding:20px; }
.card { border:1px solid #ddd; border-radius:8px; padding:16px; }
.header { display:flex; justify-content:space-between; align-items:center; margin-bottom:12px; }
.logo { width:80px; height:80px; overflow:hidden; border:1px solid #ccc; padding:4px; border-radius:6px; }
.school-info { text-align:right; font-size:12px; line-height:1.3; }
.school-info h1 { font-size:16px; margin:0; color:#0b3a59; }
.title { text-align:center; margin:8px 0 14px 0; }
.title h2 { margin:0; font-size:15px; color:#0b3a59; }
.student-box { display:flex; justify-content:space-between; gap:12px; background:#f9f9f9; border:1px solid #eee; padding:8px 12px; border-radius:6px; margin-bottom:12px; font-size:12px; }
.student-box p { margin:3px 0; }
table.results { width:100%; border-collapse:collapse; font-size:12px; margin-top:10px; }
table.results th, table.results td { border:1px solid #ccc; padding:6px; }
table.results th { background:#f1f5f9; color:#0b3a59; text-align:left; }
.summary { margin-top:14px; display:flex; justify-content:flex-end; }
.summary .box { border:1px solid #ddd; border-radius:6px; padding:8px 12px; font-size:12px; }
.summary .box strong { display:block; font-size:13px; margin-bottom:4px; color:#0b3a59; }
.footer { margin-top:20px; font-size:10px; color:#777; text-align:center; border-top:1px dashed #ccc; padding-top:6px; }
</style>
</head>
<body>
<div class="card">
<div class="header">
<div class="logo">' . $logo_html . '</div>
<div class="school-info">
<h1>'.htmlspecialchars($institute_name).'</h1>
<p>Generated: '.date("d M Y, H:i").'</p>
</div>
</div>
<div class="title"><h2>Student Result Sheet</h2></div>
<div class="student-box">
<div>
<p><strong>Name:</strong> '.htmlspecialchars($student['name']).'</p>
<p><strong>Class:</strong> '.htmlspecialchars($student['class']).'</p>
<p><strong>Section:</strong> '.htmlspecialchars($student['section']).'</p>
</div>
<div>
<p><strong>Roll:</strong> '.htmlspecialchars($student['roll']).'</p>
<p><strong>Parent:</strong> '.htmlspecialchars($student['parent_number']).'</p>
<p><strong>ID:</strong> '.htmlspecialchars($student['id']).'</p>
</div>
</div>
<table class="results">
<thead>
<tr>
<th style="width:50%;">Subject</th>
<th style="width:25%;">Mark</th>
<th style="width:25%;">GPA</th>
</tr>
</thead>
<tbody>
'.$subject_rows.'
</tbody>
</table>
<div class="summary">
<div class="box">
<strong>Summary</strong>
Total Marks: '.number_format($total_marks,2).'<br>
GPA: '.number_format($avg_gpa,2).'<br>
Status: '.$final_status_html.'
</div>
</div>
<div class="footer">
<small>Result generated by SM Teacher — Please contact your institute for queries.</small>
</div>
</div>
</body>
</html>';



// DomPDF render
$options = new Options();
$options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4','portrait');
$dompdf->render();

// Save file locally
$folder = __DIR__ . "/uploads/results/";
if (!is_dir($folder)) mkdir($folder,0777,true);
$filename = "result_" . time() . ".pdf";
$filepath_local = $folder . $filename;
file_put_contents($filepath_local, $dompdf->output());

// Web URL for DB
$pdf_link = "https://teacher.sm10x.xyz/uploads/results/" . $filename;

// Save to DB
$stmt = $conn->prepare("INSERT INTO result_pdfs (teacher_id, student_id, class, roll, student_name, pdf_link) VALUES (?, ?, ?, ?, ?, ?)");
$stmt->bind_param("iissss", $teacher_id, $student_id, $student['class'], $student['roll'], $student['name'], $pdf_link);
$stmt->execute();


// Redirect with alert
echo "<script>alert('✅ PDF generated successfully!'); window.location.href='view-results.php';</script>";
?>
