<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include "config.php";

if (!isset($_SESSION['teacher_email'])) {
    header("Location: login.php");
    exit;
}

$email = $_SESSION['teacher_email'];
$stmt = $conn->prepare("SELECT id FROM teachers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$teacher = $stmt->get_result()->fetch_assoc();
$teacher_id = $teacher['id'];

// Helper function: Generate unique 7-digit ID starting with 2
function generate_student_id($conn) {
    do {
        $rand_id = '2' . str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
        $check = $conn->query("SELECT student_id FROM students WHERE student_id='$rand_id'");
    } while($check->num_rows > 0);
    return $rand_id;
}

// --- Add Student ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_student'])) {
    $name = trim($_POST['name']);
    $phone = trim($_POST['phone']);
    $class = trim($_POST['class']);
    $section = trim($_POST['section']);
    $parent = trim($_POST['parent']);
    $student_id = generate_student_id($conn);

    $roll_res = $conn->query("SELECT MAX(roll) AS max_roll FROM students WHERE class='$class' AND section='$section'");
    $roll_row = $roll_res->fetch_assoc();
    $roll = $roll_row['max_roll'] ? $roll_row['max_roll'] + 1 : 1;

    // Upload files
    $uploads = ['photo','birth_cert_front','birth_cert_back','father_nid_front','father_nid_back','mother_nid_front','mother_nid_back'];
    $uploaded_files = [];
    foreach ($uploads as $file) {
        if(isset($_FILES[$file]) && $_FILES[$file]['tmp_name'] != '') {
            $filename = time().'_'.basename($_FILES[$file]['name']);
            move_uploaded_file($_FILES[$file]['tmp_name'], "uploads/$filename");
            $uploaded_files[$file] = $filename;
        } else {
            $uploaded_files[$file] = null;
        }
    }

    $insert = $conn->prepare("INSERT INTO students 
    (teacher_id, name, phone, class, section, roll, parent_number, student_id, photo, birth_cert_front, birth_cert_back, father_nid_front, father_nid_back, mother_nid_front, mother_nid_back) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $insert->bind_param("issssisssssssss",
        $teacher_id, $name, $phone, $class, $section, $roll, $parent, $student_id,
        $uploaded_files['photo'], $uploaded_files['birth_cert_front'], $uploaded_files['birth_cert_back'],
        $uploaded_files['father_nid_front'], $uploaded_files['father_nid_back'],
        $uploaded_files['mother_nid_front'], $uploaded_files['mother_nid_back']
    );
    $insert->execute();
    header("Location: students.php?added=1");
    exit;
}

// --- Filters ---
$class_filter = $_GET['class'] ?? '';
$section_filter = $_GET['section'] ?? '';
$search = $_GET['q'] ?? '';

$where = "teacher_id = $teacher_id";
if($class_filter != '') $where .= " AND class='$class_filter'";
if($section_filter != '') $where .= " AND section='$section_filter'";
if($search != '') {
    $s = $conn->real_escape_string($search);
    $where .= " AND (name LIKE '%$s%' OR roll LIKE '%$s%')";
}

$students = $conn->query("SELECT * FROM students WHERE $where ORDER BY class, section, roll");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Student Management | SM Teacher</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<script src="https://cdn.tailwindcss.com"></script>
<link rel="stylesheet" href="https://unpkg.com/aos@2.3.1/dist/aos.css"/>
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
body {
  background: linear-gradient(135deg,#020617,#0f172a);
  color: #f8fafc;
  font-family: "Inter", sans-serif;
}
.glass {
  background: rgba(255,255,255,0.05);
  backdrop-filter: blur(10px);
  border: 1px solid rgba(255,255,255,0.1);
}
.table-header {
  background: rgba(30,41,59,0.7);
  color: #93c5fd;
}
.table-row:hover {
  background: rgba(51,65,85,0.6);
}
.btn-primary {
  background: linear-gradient(to right,#38bdf8,#3b82f6);
  color: white;
}
.btn-primary:hover {
  background: linear-gradient(to right,#2563eb,#1d4ed8);
}
</style>
</head>
<body class="min-h-screen flex">
<!-- Sidebar -->
<div class="w-64 bg-slate-900 p-6 flex flex-col gap-4 shadow-xl">
  <h2 class="text-2xl font-bold text-sky-400 mb-4">SM Teacher</h2>
  <a href="dashboard.php" class="hover:text-sky-400">Dashboard</a>
  <a href="students.php" class="text-sky-400 font-bold">Students</a>
  <a href="results.php" class="hover:text-sky-400">Results</a>
  <a href="notices.php" class="hover:text-sky-400">Notices</a>
  <a href="logout.php" class="hover:text-red-400 mt-auto">Logout</a>
</div>

<!-- Main -->
<div class="flex-1 p-8 overflow-auto">
  <h1 class="text-3xl font-bold text-sky-400 mb-6">📚 Students Management</h1>

  <!-- Filters -->
  <form method="GET" class="flex gap-2 mb-4 flex-wrap">
    <select name="class" class="bg-slate-800 p-2 rounded">
      <option value="">Class</option>
      <?php for($i=1;$i<=10;$i++): ?>
      <option value="<?= $i ?>" <?= $class_filter==$i?'selected':'' ?>><?= $i ?></option>
      <?php endfor; ?>
    </select>
    <select name="section" class="bg-slate-800 p-2 rounded">
      <option value="">Section</option>
      <?php foreach(['A','B','C','D','E'] as $sec): ?>
      <option value="<?= $sec ?>" <?= $section_filter==$sec?'selected':'' ?>><?= $sec ?></option>
      <?php endforeach; ?>
    </select>
    <input type="text" name="q" placeholder="Search name or roll" value="<?= htmlspecialchars($search) ?>" class="bg-slate-800 p-2 rounded">
    <button class="btn-primary px-4 py-2 rounded">Search</button>
  </form>

  <!-- Add Student -->
  <form method="POST" enctype="multipart/form-data" class="grid grid-cols-1 md:grid-cols-3 gap-4 glass p-4 rounded-xl mb-8">
    <input type="hidden" name="add_student" value="1">
    <input type="text" name="name" placeholder="Student Name" required class="p-2 rounded bg-slate-800">
    <input type="text" name="phone" placeholder="Phone" required class="p-2 rounded bg-slate-800">
    <select name="class" required class="p-2 rounded bg-slate-800">
      <option value="">Class</option>
      <?php for($i=1;$i<=10;$i++): ?>
      <option value="<?= $i ?>"><?= $i ?></option>
      <?php endfor; ?>
    </select>
    <select name="section" required class="p-2 rounded bg-slate-800">
      <option value="">Section</option>
      <?php foreach(['A','B','C','D','E'] as $sec): ?>
      <option value="<?= $sec ?>"><?= $sec ?></option>
      <?php endforeach; ?>
    </select>
    <input type="text" name="parent" placeholder="Parent Number" class="p-2 rounded bg-slate-800">
    <input type="file" name="photo" class="p-2 rounded bg-slate-800" accept="image/*">
    <input type="file" name="birth_cert_front" class="p-2 rounded bg-slate-800">
    <input type="file" name="birth_cert_back" class="p-2 rounded bg-slate-800">
    <input type="file" name="father_nid_front" class="p-2 rounded bg-slate-800">
    <input type="file" name="father_nid_back" class="p-2 rounded bg-slate-800">
    <input type="file" name="mother_nid_front" class="p-2 rounded bg-slate-800">
    <input type="file" name="mother_nid_back" class="p-2 rounded bg-slate-800">
    <button type="submit" class="btn-primary px-4 py-2 rounded font-semibold mt-2 col-span-full">➕ Add Student</button>
  </form>

  <!-- Students Table -->
  <div class="overflow-auto glass p-4 rounded-xl">
    <table class="w-full text-sm">
      <thead class="table-header">
        <tr>
          <th>Photo</th>
          <th>ID</th>
          <th>Name</th>
          <th>Class</th>
          <th>Section</th>
          <th>Roll</th>
          <th>Parent</th>
          <th>Docs</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody>
      <?php while($row = $students->fetch_assoc()): ?>
        <tr class="border-b border-slate-700 table-row">
          <td><?php if($row['photo']): ?><img src="uploads/<?= $row['photo'] ?>" class="w-12 h-12 rounded"><?php endif; ?></td>
          <td><?= $row['student_id'] ?></td>
          <td><?= htmlspecialchars($row['name']) ?></td>
          <td><?= $row['class'] ?></td>
          <td><?= $row['section'] ?></td>
          <td><?= $row['roll'] ?></td>
          <td><?= $row['parent_number'] ?></td>
          <td><button onclick="previewDocs(<?= $row['id'] ?>)" class="text-sky-400 underline">View</button></td>
          <td>
            <a href="edit_student.php?id=<?= $row['id'] ?>" class="text-green-400">Edit</a> |
            <a href="delete_student.php?id=<?= $row['id'] ?>" class="text-red-400">Delete</a>
          </td>
        </tr>
      <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- Document Modal -->
<div id="docModal" class="hidden fixed inset-0 bg-black bg-opacity-80 flex items-center justify-center z-50">
  <div class="bg-slate-900 p-6 rounded-2xl max-w-2xl w-full relative shadow-2xl">
    <button onclick="closeDocModal()" class="absolute top-3 right-4 text-red-400 text-2xl font-bold">×</button>
    <h2 class="text-xl font-bold text-sky-400 mb-4">📄 Student Documents</h2>
    <div id="docContent" class="grid grid-cols-2 gap-3"></div>
  </div>
</div>

<script>
AOS.init({ duration: 800 });
if(window.location.search.includes('added=1')){
  Swal.fire({ icon: 'success', title: 'Student Added!', timer: 1500, showConfirmButton: false });
}

function previewDocs(id){
  fetch('preview_docs.php?id='+id)
  .then(res=>res.json())
  .then(data=>{
    let html = '';
    for(const key in data){
      if(data[key]){
        const file = data[key];
        const ext = file.split('.').pop().toLowerCase();
        const filePath = 'uploads/'+file;
        html += `
          <div class='bg-slate-800 p-2 rounded'>
            <b class='text-sky-300'>${key}</b><br>
            <img src="${filePath}" class='w-full h-40 object-contain rounded my-2'>
            <a href="${filePath}" download class='text-yellow-400 underline text-sm'>Download</a>
          </div>`;
      }
    }
    document.getElementById('docContent').innerHTML = html || '<p class="text-center text-slate-400">No documents uploaded.</p>';
    document.getElementById('docModal').classList.remove('hidden');
  });
}
function closeDocModal(){ document.getElementById('docModal').classList.add('hidden'); }
</script>
</body>
</html>
