<?php
session_start();
include "config.php";

if (!isset($_SESSION['teacher_email'])) {
  header("Location: login.php");
  exit;
}

$email = $_SESSION['teacher_email'];
$stmt = $conn->prepare("SELECT * FROM teachers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$teacher = $stmt->get_result()->fetch_assoc();
$teacher_id = $teacher['id'];

$response = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $template = trim($_POST['template']);

  $check = $conn->query("SELECT * FROM result_sms_template WHERE teacher_id = $teacher_id");
  if ($check->num_rows > 0) {
    $conn->query("UPDATE result_sms_template SET template = '$template' WHERE teacher_id = $teacher_id");
  } else {
    $conn->query("INSERT INTO result_sms_template (teacher_id, template) VALUES ($teacher_id, '$template')");
  }

  $response = "✅ Template updated successfully.";
}

$tempRes = $conn->query("SELECT template FROM result_sms_template WHERE teacher_id = $teacher_id");
$existing = $tempRes->fetch_assoc()['template'] ?? "Dear guardian, your student \$name got \$result in \$exam from \$institute.";
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Edit Result SMS Template</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 text-white p-6 min-h-screen">
  <div class="max-w-3xl mx-auto">
    <h1 class="text-2xl font-bold text-yellow-400 mb-4">📝 Edit Result SMS Template</h1>
    <a href="dashboard.php" class="text-sm text-sky-400 hover:underline mb-6 inline-block">← Back to Dashboard</a>

    <?php if ($response): ?>
      <div class="bg-green-600 p-3 rounded mb-4 text-sm"><?= htmlspecialchars($response) ?></div>
    <?php endif; ?>

    <form method="POST" class="bg-slate-800 p-4 rounded-xl space-y-4">
      <label class="block text-sm text-gray-300">✍️ SMS Template:</label>
      <textarea name="template" rows="5" class="w-full bg-slate-700 p-3 rounded text-sm"><?= htmlspecialchars($existing) ?></textarea>

      <p class="text-sm text-gray-400">
        You can use the following tags:
        <code class="bg-slate-700 px-2 py-1 rounded text-yellow-300">$name</code>,
        <code class="bg-slate-700 px-2 py-1 rounded text-yellow-300">$result</code>,
        <code class="bg-slate-700 px-2 py-1 rounded text-yellow-300">$exam</code>,
        <code class="bg-slate-700 px-2 py-1 rounded text-yellow-300">$institute</code>
      </p>

      <button type="submit" class="bg-yellow-400 text-black px-6 py-2 rounded font-semibold hover:bg-yellow-300">
        💾 Save Template
      </button>
    </form>
  </div>
</body>
</html>
