<?php
session_start();
include "config.php";

if (!isset($_SESSION['teacher_email'])) {
  header("Location: login.php");
  exit;
}

$email = $_SESSION['teacher_email'];
$stmt = $conn->prepare("SELECT id FROM teachers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();
$teacher = $result->fetch_assoc();
$teacher_id = $teacher['id'];

$res = $conn->prepare("SELECT * FROM result_pdfs WHERE teacher_id = ? ORDER BY id DESC");
$res->bind_param("i", $teacher_id);
$res->execute();
$pdfs = $res->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>📄 View Results</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    function copyToClipboard(text) {
      navigator.clipboard.writeText(text).then(() => {
        alert("✅ Link copied!");
      }).catch(err => {
        alert("❌ Failed to copy link.");
      });
    }
  </script>
</head>
<body class="bg-slate-900 text-white p-6">
  <div class="max-w-6xl mx-auto">
    <div class="flex justify-between items-center mb-6">
      <h1 class="text-2xl font-bold text-yellow-400">📄 Generated Results</h1>
      <a href="result-make.php" class="text-sm text-sky-400 hover:underline">⬅️ Back to Result Maker</a>
      <a href="dashboard.php" class="text-sm text-sky-400 hover:underline">← Back to Dashboard</a>
    </div>

    <?php if ($pdfs->num_rows > 0): ?>
      <div class="overflow-x-auto">
        <table class="w-full text-sm text-left bg-slate-800 rounded-lg">
          <thead class="bg-slate-700 text-yellow-300">
            <tr>
              <th class="px-4 py-3">Student</th>
              <th class="px-4 py-3">Class</th>
              <th class="px-4 py-3">Roll</th>
              <th class="px-4 py-3">Created At</th>
              <th class="px-4 py-3">PDF</th>
              <th class="px-4 py-3">Link</th>
            </tr>
          </thead>
          <tbody>
            <?php while($row = $pdfs->fetch_assoc()): ?>
              <tr class="border-b border-slate-700 hover:bg-slate-700 transition">
                <td class="px-4 py-2"><?= htmlspecialchars($row['student_name']) ?></td>
                <td class="px-4 py-2"><?= htmlspecialchars($row['class']) ?></td>
                <td class="px-4 py-2"><?= htmlspecialchars($row['roll']) ?></td>
                <td class="px-4 py-2"><?= htmlspecialchars($row['created_at']) ?></td>
                <td class="px-4 py-2">
                  <a href="<?= htmlspecialchars($row['pdf_link']) ?>" target="_blank" class="text-yellow-400 underline hover:text-yellow-300">📥 View</a>
                </td>
                <td class="px-4 py-2">
                  <div class="flex items-center space-x-2">
                    <input type="text" readonly value="<?= htmlspecialchars($row['pdf_link']) ?>" class="w-64 p-1 bg-slate-700 text-white rounded text-xs" />
                    <button onclick="copyToClipboard('<?= htmlspecialchars($row['pdf_link']) ?>')" class="bg-yellow-400 text-black px-2 py-1 rounded text-xs hover:bg-yellow-300">Copy</button>
                  </div>
                </td>
              </tr>
            <?php endwhile; ?>
          </tbody>
        </table>
      </div>
    <?php else: ?>
      <div class="bg-red-600 text-white p-4 rounded">No result PDFs found.</div>
    <?php endif; ?>
  </div>
</body>
</html>
