<?php
// admin/create-admin.php
session_start();
include "../config.php";

$success = "";
$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email = trim($_POST['email']);
  $password = trim($_POST['password']);

  if (filter_var($email, FILTER_VALIDATE_EMAIL) && strlen($password) >= 6) {
    $check = $conn->prepare("SELECT id FROM admin WHERE email = ?");
    $check->bind_param("s", $email);
    $check->execute();
    $result = $check->get_result();

    if ($result->num_rows > 0) {
      $error = "🚫 Admin with this email already exists.";
    } else {
      $hashed = password_hash($password, PASSWORD_DEFAULT);
      $stmt = $conn->prepare("INSERT INTO admin (email, password) VALUES (?, ?)");
      $stmt->bind_param("ss", $email, $hashed);
      $stmt->execute();
      $success = "✅ Admin created successfully.";
    }
  } else {
    $error = "❌ Please enter a valid email and password (min 6 chars).";
  }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Create Admin</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 text-white flex items-center justify-center min-h-screen">
  <div class="w-full max-w-sm p-6 bg-slate-800 rounded-xl">
    <h1 class="text-2xl font-bold text-center text-yellow-400 mb-4">🛡️ Create Admin</h1>

    <?php if ($success): ?>
      <div class="bg-green-600 text-white p-3 rounded mb-4 text-sm"><?= htmlspecialchars($success) ?></div>
    <?php elseif ($error): ?>
      <div class="bg-red-600 text-white p-3 rounded mb-4 text-sm"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="POST" class="space-y-4">
      <input type="email" name="email" placeholder="Admin Email" required class="w-full px-4 py-2 bg-slate-700 rounded" />
      <input type="password" name="password" placeholder="Password (min 6 chars)" required class="w-full px-4 py-2 bg-slate-700 rounded" />
      <button type="submit" class="w-full bg-yellow-400 text-black font-bold py-2 rounded hover:bg-yellow-300">➕ Create Admin</button>
    </form>

    <div class="mt-6 text-center">
      <a href="login.php" class="text-sky-400 hover:underline text-sm">🔐 Back to Admin Login</a>
    </div>
  </div>
</body>
</html>
