<?php
// admin/dashboard.php
include "../config.php";

session_start();
if (!isset($_SESSION['admin_email'])) {
  header("Location: login.php");
  exit;
}


// Fetch statistics
$teachers_count = $conn->query("SELECT COUNT(*) as total FROM teachers")->fetch_assoc()['total'];
$students_count = $conn->query("SELECT COUNT(*) as total FROM students")->fetch_assoc()['total'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Admin Dashboard</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="flex bg-slate-900 text-white min-h-screen">

  <!-- Sidebar -->
  <aside class="w-64 bg-slate-800 p-6 space-y-4">
    <h1 class="text-2xl font-bold text-yellow-400 mb-6">👑 Admin Panel</h1>
    <nav class="space-y-2 text-sm">
      <a href="dashboard.php" class="block px-3 py-2 bg-slate-700 rounded hover:bg-slate-600">📊 Dashboard</a>
      <a href="teachers.php" class="block px-3 py-2 hover:bg-slate-700 rounded">👩‍🏫 All Teachers</a>
      <a href="students.php" class="block px-3 py-2 hover:bg-slate-700 rounded">🎓 All Students</a>
      <a href="reset-password.php" class="block px-3 py-2 hover:bg-slate-700 rounded">🔑 Reset Password</a>
      <a href="logout.php" class="block px-3 py-2 text-red-400 hover:bg-slate-700 rounded">🚪 Logout</a>
    </nav>
  </aside>

  <!-- Main Content -->
  <main class="flex-1 p-8">
    <h2 class="text-3xl font-bold text-yellow-300 mb-6">📊 Dashboard Overview</h2>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
      <div class="bg-slate-800 p-6 rounded-xl shadow">
        <h3 class="text-xl font-semibold text-sky-300">👩‍🏫 Total Teachers</h3>
        <p class="text-3xl font-bold mt-2 text-yellow-400"><?= $teachers_count ?></p>
      </div>
      <div class="bg-slate-800 p-6 rounded-xl shadow">
        <h3 class="text-xl font-semibold text-sky-300">🎓 Total Students</h3>
        <p class="text-3xl font-bold mt-2 text-yellow-400"><?= $students_count ?></p>
      </div>
    </div>
  </main>

</body>
</html>
