<?php
session_start();
include "../config.php";
if (!isset($_SESSION['admin_email'])) {
  header("Location: login.php");
  exit;
}

$result = $conn->query("
  SELECT students.*, teachers.name AS teacher_name 
  FROM students 
  JOIN teachers ON students.teacher_id = teachers.id 
  ORDER BY students.id DESC
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>All Students | Admin Panel</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 text-white min-h-screen flex">
  <!-- Sidebar -->
  <div class="w-64 bg-slate-800 p-6 space-y-4">
    <h1 class="text-xl font-bold text-yellow-400">⚙️ Admin Panel</h1>
    <nav class="space-y-2">
      <a href="dashboard.php" class="block text-white hover:text-yellow-400">🏠 Dashboard</a>
      <a href="teachers.php" class="block text-white hover:text-yellow-400">👩‍🏫 Teachers</a>
      <a href="students.php" class="block text-yellow-400 font-bold">📚 Students</a>
      <a href="reset-password.php" class="block text-white hover:text-yellow-400">🔑 Reset Password</a>
      <a href="logout.php" class="block text-red-400 hover:underline">🚪 Logout</a>
    </nav>
  </div>

  <!-- Main Content -->
  <div class="flex-1 p-10">
    <h2 class="text-3xl font-bold text-yellow-400 mb-6">📚 All Students</h2>
    <div class="overflow-x-auto">
      <table class="w-full table-auto bg-slate-800 rounded-xl overflow-hidden text-sm">
        <thead class="bg-slate-700 text-yellow-300">
          <tr>
            <th class="px-3 py-2 text-left">#</th>
            <th class="px-3 py-2 text-left">Student</th>
            <th class="px-3 py-2 text-left">Class</th>
            <th class="px-3 py-2 text-left">Roll</th>
            <th class="px-3 py-2 text-left">Phone</th>
            <th class="px-3 py-2 text-left">Parent</th>
            <th class="px-3 py-2 text-left">Teacher</th>
          </tr>
        </thead>
        <tbody class="text-slate-300">
          <?php $i = 1; while($row = $result->fetch_assoc()): ?>
            <tr class="border-b border-slate-700 hover:bg-slate-700">
              <td class="px-3 py-2"><?= $i++ ?></td>
              <td class="px-3 py-2"><?= htmlspecialchars($row['name']) ?></td>
              <td class="px-3 py-2"><?= htmlspecialchars($row['class']) ?></td>
              <td class="px-3 py-2"><?= htmlspecialchars($row['roll']) ?></td>
              <td class="px-3 py-2"><?= htmlspecialchars($row['phone']) ?></td>
              <td class="px-3 py-2"><?= htmlspecialchars($row['parent_number']) ?></td>
              <td class="px-3 py-2"><?= htmlspecialchars($row['teacher_name']) ?></td>
            </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>
</body>
</html>
