<?php
session_start();
include "config.php";

if (!isset($_SESSION['teacher_email'])) {
  header("Location: login.php");
  exit;
}

$email = $_SESSION['teacher_email'];
$stmt = $conn->prepare("SELECT id, api_key FROM teachers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$res = $stmt->get_result();
$teacher = $res->fetch_assoc();
$teacher_id = $teacher['id'];
$api_key = $teacher['api_key'] ?? ($_SESSION['api_key'] ?? '');

$status = "";
$sent_numbers = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['message'])) {
  $message = trim($_POST['message']);

  $students = $conn->query("SELECT name, parent_number FROM students WHERE teacher_id = $teacher_id");

  while ($row = $students->fetch_assoc()) {
    $number = preg_replace('/[^0-9]/', '', $row['parent_number']);
    if (strlen($number) >= 10) {
      $payload = [
        "api" => $api_key,
        "number" => $number,
        "message" => $message
      ];

      $ch = curl_init("https://panel.sm10x.xyz/sent_sms_post.php");
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_POST, true);
      curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
      curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
      curl_exec($ch);
      curl_close($ch);

      $conn->query("INSERT INTO sms_logs (teacher_id, number, message, status) 
        VALUES ($teacher_id, '$number', '" . $conn->real_escape_string($message) . "', 'broadcast')");

      $sent_numbers[] = "{$row['name']} - $number";
    }
  }

  $status = count($sent_numbers) . " notice(s) sent successfully.";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>📢 Notice Broadcast | SM Teacher</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    function updatePreview() {
      const msg = document.getElementById('message').value;
      document.getElementById('preview').innerText = msg;
      document.getElementById('charCount').innerText = msg.length + " characters";
    }

    function confirmSend(e) {
      if (!confirm("Are you sure you want to send this notice to all parents?")) {
        e.preventDefault();
      }
    }
  </script>
</head>
<body class="bg-slate-900 text-white min-h-screen p-6">
  <div class="max-w-2xl mx-auto">
    <h1 class="text-2xl font-bold text-yellow-400 mb-4">📢 Notice Broadcast</h1>

    <?php if ($status): ?>
      <div class="bg-green-600 p-3 rounded mb-4">✅ <?= htmlspecialchars($status) ?></div>

      <div class="bg-slate-800 p-4 rounded mb-4 max-h-64 overflow-y-auto">
        <p class="text-yellow-300 font-semibold mb-2">📋 SMS Sent To:</p>
        <ul class="list-disc pl-5 text-sm text-gray-300 space-y-1">
          <?php foreach ($sent_numbers as $line): ?>
            <li><?= htmlspecialchars($line) ?></li>
          <?php endforeach; ?>
        </ul>
      </div>
    <?php endif; ?>

    <form method="POST" class="space-y-4" onsubmit="confirmSend(event)">
      <textarea name="message" id="message" oninput="updatePreview()" required placeholder="Type your notice message here..." class="w-full p-4 rounded bg-slate-800 text-white" maxlength="500"></textarea>
      <div class="text-sm text-gray-400" id="charCount">0 characters</div>

      <div class="bg-slate-800 p-4 rounded">
        <p class="text-yellow-300 mb-2 font-semibold">📄 SMS Preview:</p>
        <div id="preview" class="bg-slate-700 p-3 rounded text-sm whitespace-pre-line min-h-[60px]"></div>
      </div>

      <button class="bg-yellow-400 hover:bg-yellow-300 text-black px-4 py-2 rounded font-bold">📤 Send Notice</button>
    </form>

    <div class="mt-6">
      <a href="dashboard.php" class="text-yellow-300 hover:underline">⬅️ Back to Dashboard</a>
    </div>
  </div>
</body>
</html>
