<?php
// register.php (Logic at top)
include "config.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name     = trim($_POST['name']);
    $username = trim($_POST['username']);
    $email    = trim($_POST['email']);
    $phone    = trim($_POST['phone']);
    $institute= trim($_POST['institute']);
    $address  = trim($_POST['address']);
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);

    // Check if email or username already exists
    $check = $conn->prepare("SELECT id FROM teachers WHERE email = ? OR username = ?");
    $check->bind_param("ss", $email, $username);
    $check->execute();
    $check->store_result();

    if ($check->num_rows > 0) {
        $error = "Email or Username already taken!";
    } else {
        $insert = $conn->prepare("INSERT INTO teachers (name, username, email, phone, institute_name, address, password) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $insert->bind_param("sssssss", $name, $username, $email, $phone, $institute, $address, $password);
        if ($insert->execute()) {
            header("Location: login.php?registered=1");
            exit;
        } else {
            $error = "Registration failed!";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Register | SM Teacher</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 text-white flex items-center justify-center min-h-screen">
  <div class="w-full max-w-md bg-slate-800 p-8 rounded-xl shadow-xl">
    <h2 class="text-2xl font-bold mb-6 text-center text-yellow-400">👨‍🏫 Register as Teacher</h2>

    <?php if (isset($error)) echo "<p class='text-red-500 mb-4 text-center'>$error</p>"; ?>

    <form method="POST" class="space-y-4">
      <input type="text" name="name" placeholder="Full Name"
        class="w-full px-4 py-3 rounded-lg bg-slate-700 focus:outline-none focus:ring-2 focus:ring-yellow-400" required />

      <input type="text" name="username" placeholder="Username"
        class="w-full px-4 py-3 rounded-lg bg-slate-700 focus:outline-none focus:ring-2 focus:ring-yellow-400" required />

      <input type="email" name="email" placeholder="Email address"
        class="w-full px-4 py-3 rounded-lg bg-slate-700 focus:outline-none focus:ring-2 focus:ring-yellow-400" required />

      <input type="text" name="phone" placeholder="Phone Number"
        class="w-full px-4 py-3 rounded-lg bg-slate-700 focus:outline-none focus:ring-2 focus:ring-yellow-400" required />

      <input type="text" name="institute" placeholder="Institute Name"
        class="w-full px-4 py-3 rounded-lg bg-slate-700 focus:outline-none focus:ring-2 focus:ring-yellow-400" required />

      <textarea name="address" placeholder="Address"
        class="w-full px-4 py-3 rounded-lg bg-slate-700 focus:outline-none focus:ring-2 focus:ring-yellow-400" required></textarea>

      <input type="password" name="password" placeholder="Create Password"
        class="w-full px-4 py-3 rounded-lg bg-slate-700 focus:outline-none focus:ring-2 focus:ring-yellow-400" required />

      <button type="submit"
        class="w-full py-3 bg-yellow-400 hover:bg-yellow-300 text-black font-semibold rounded-lg">Register</button>
    </form>

    <p class="mt-6 text-center text-sm text-slate-400">
      Already have an account? <a href="login.php" class="text-yellow-300 hover:underline">Login</a>
    </p>
  </div>
</body>
</html>