<?php
session_start();
include "config.php";

if (!isset($_SESSION['teacher_email'])) {
  header("Location: login.php");
  exit;
}

$email = $_SESSION['teacher_email'];
$stmt = $conn->prepare("SELECT * FROM teachers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$teacher = $stmt->get_result()->fetch_assoc();
$teacher_id = $teacher['id'];

$students = [];
if (isset($_GET['class']) && $_GET['class'] !== '') {
  $class = $_GET['class'];
  $students = $conn->query("SELECT * FROM students WHERE teacher_id = $teacher_id AND class = '$class'");
}
?>

<!DOCTYPE html>
<html>
<head>
  <title>Result Sheet Generator</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    function addRow() {
      const container = document.getElementById("subjects");
      const row = document.createElement("div");
      row.className = "flex items-center gap-2 mb-2";
      row.innerHTML = `
        <input name="subject[]" type="text" placeholder="Subject" class="w-1/3 p-2 bg-slate-800 rounded text-white" required>
        <input name="mark[]" type="number" placeholder="Mark" class="w-1/3 p-2 bg-slate-800 rounded text-white mark-input" oninput="updateGPA()" required>
        <input type="text" class="w-1/4 p-2 bg-slate-700 rounded text-white subject-gpa" readonly placeholder="GPA">
        <button type="button" onclick="this.parentElement.remove(); updateGPA()" class="text-red-400">🗑️</button>
      `;
      container.appendChild(row);
    }

    function updateGPA() {
      const marks = document.querySelectorAll(".mark-input");
      const gpas = document.querySelectorAll(".subject-gpa");
      let total = 0, totalGPA = 0;

      marks.forEach((input, idx) => {
        let mark = parseFloat(input.value) || 0;
        let gpa = mark >= 80 ? 5 : mark >= 70 ? 4 : mark >= 60 ? 3.5 : mark >= 50 ? 3 : mark >= 40 ? 2 : mark >= 33 ? 1 : 0;
        gpas[idx].value = gpa.toFixed(2);
        total += mark;
        totalGPA += gpa;
      });

      document.getElementById("total").innerText = total.toFixed(2);
      document.getElementById("final_gpa").innerText = (marks.length > 0 ? totalGPA / marks.length : 0).toFixed(2);
    }
  </script>
</head>
<body class="bg-slate-900 text-white p-6">
  <div class="max-w-4xl mx-auto space-y-6">
    <h1 class="text-3xl text-yellow-400 font-bold mb-4">📄 Result Sheet Generator</h1>
    <a href="dashboard.php" class="text-sm text-sky-400 hover:underline">← Back to Dashboard</a>

    <!-- Search Student -->
    <form method="GET" class="flex gap-4 mb-4">
      <input type="text" name="class" placeholder="Enter Class" value="<?= htmlspecialchars($_GET['class'] ?? '') ?>" class="p-2 rounded bg-slate-800 text-white">
      <button type="submit" class="bg-yellow-400 text-black px-4 py-2 rounded font-bold">Search</button>
    </form>

    <?php if (!empty($_GET['class'])): ?>
    <form method="POST" action="result-generate.php">
      <label class="block mb-2 text-sm">👩‍🎓 Select Student:</label>
      <select name="student_id" required class="w-full p-2 bg-slate-800 rounded mb-4 text-white">
        <option value="">-- Select Student --</option>
        <?php while ($s = $students->fetch_assoc()): ?>
          <option value="<?= $s['id'] ?>">
            <?= htmlspecialchars($s['name']) ?> | Class: <?= $s['class'] ?> | Roll: <?= $s['roll'] ?>
          </option>
        <?php endwhile; ?>
      </select>

      <div id="subjects" class="mb-4"></div>
      <button type="button" onclick="addRow()" class="bg-blue-600 px-3 py-2 rounded text-white mb-4">➕ Add Subject</button>

      <!-- Preview -->
      <div class="bg-slate-800 p-4 rounded">
        <p>Total Marks: <span id="total" class="text-yellow-300">0.00</span></p>
        <p>Final GPA: <span id="final_gpa" class="text-yellow-300">0.00</span></p>
      </div>

      <button type="submit" class="w-full mt-4 bg-yellow-400 text-black py-3 font-bold rounded hover:bg-yellow-300">📥 Generate PDF</button>
    </form>
    <?php endif; ?>
  </div>
</body>
</html>
