<?php
file_put_contents("cron-log.txt", date("Y-m-d H:i:s") . " Cron Running\n", FILE_APPEND);
error_reporting(E_ALL);
ini_set('display_errors', 1);

// send_scheduled_sms.php
include "config.php";

date_default_timezone_set("Asia/Dhaka");

$now = date("Y-m-d H:i:s");

// Fetch pending messages that are due
$sql = "SELECT s.id, s.teacher_id, s.number, s.message, t.api_key 
        FROM scheduled_sms s
        JOIN teachers t ON s.teacher_id = t.id
        WHERE s.status = 'pending' AND s.schedule_time <= ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $now);
$stmt->execute();
$res = $stmt->get_result();

while ($row = $res->fetch_assoc()) {
    $smsData = [
        "api" => $row['api_key'],
        "number" => $row['number'],
        "message" => $row['message']
    ];

    $ch = curl_init("https://panel.sm10x.xyz/sent_sms_post.php");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($smsData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);

    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);

    // Update status
    $status = $error ? 'failed' : 'sent';

    $update = $conn->prepare("UPDATE scheduled_sms SET status = ? WHERE id = ?");
    $update->bind_param("si", $status, $row['id']);
    $update->execute();

    // Optional: Log to sms_logs
    $log = $conn->prepare("INSERT INTO sms_logs (teacher_id, number, message, status) VALUES (?, ?, ?, ?)");
    $log->bind_param("isss", $row['teacher_id'], $row['number'], $row['message'], $status);
    $log->execute();
}

echo "✅ Cron job finished at " . date("Y-m-d H:i:s") . "\n";
