<?php
// sms-history.php
session_start();
include "config.php";

if (!isset($_SESSION['teacher_email'])) {
  header("Location: login.php");
  exit;
}

$email = $_SESSION['teacher_email'];
$stmt = $conn->prepare("SELECT id FROM teachers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();
$teacher = $result->fetch_assoc();
$teacher_id = $teacher['id'];

// Fetch SMS logs
$logs = $conn->query("SELECT sms_logs.*, students.name AS student_name FROM sms_logs LEFT JOIN students ON sms_logs.student_id = students.id WHERE sms_logs.teacher_id = $teacher_id ORDER BY sms_logs.sent_at DESC LIMIT 100");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>SMS History | SM Teacher</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 text-white min-h-screen">
  <div class="max-w-6xl mx-auto p-6">
    <div class="flex items-center justify-between mb-6">
      <h1 class="text-2xl font-bold text-yellow-400">📊 SMS History</h1>
      <a href="dashboard.php" class="text-sky-400 hover:underline">← Back to Dashboard</a>
    </div>

    <div class="bg-slate-800 p-4 rounded-xl overflow-x-auto">
      <table class="min-w-full text-sm">
        <thead>
          <tr class="bg-slate-700 text-left">
            <th class="p-2">Recipient</th>
            <th class="p-2">Message</th>
            <th class="p-2">Status</th>
            <th class="p-2">Date</th>
          </tr>
        </thead>
        <tbody>
          <?php while($row = $logs->fetch_assoc()): ?>
            <tr class="border-b border-slate-700">
              <td class="p-2">
                <?= htmlspecialchars($row['student_name'] ?: $row['number']) ?>
              </td>
              <td class="p-2">
                <?= htmlspecialchars(substr($row['message'], 0, 80)) ?>
              </td>
              <td class="p-2">
                <span class="text-green-400"><?= htmlspecialchars($row['status']) ?></span>
              </td>
              <td class="p-2">
                <?= date("d M Y, h:i A", strtotime($row['sent_at'])) ?>
              </td>
            </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>
</body>
</html>
