<?php
// attendance-report.php
session_start();
include "config.php";

if (!isset($_SESSION['teacher_email'])) {
  header("Location: login.php");
  exit;
}

$email = $_SESSION['teacher_email'];
$stmt = $conn->prepare("SELECT id FROM teachers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$res = $stmt->get_result();
$teacher = $res->fetch_assoc();
$teacher_id = $teacher['id'];

$filter = $_GET['filter'] ?? 'daily';
$date_sql = "";

if ($filter === 'weekly') {
  $date_sql = "AND date >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)";
} elseif ($filter === 'monthly') {
  $date_sql = "AND date >= DATE_SUB(CURDATE(), INTERVAL 1 MONTH)";
} else {
  $date_sql = "AND date = CURDATE()";
}

$query = "SELECT s.name, s.class, a.date, a.status
          FROM attendance a
          JOIN students s ON a.student_id = s.id
          WHERE a.marked_by = $teacher_id $date_sql
          ORDER BY a.date DESC";
$result = $conn->query($query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Attendance Report</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 text-white p-6">
  <div class="max-w-5xl mx-auto">
    <h1 class="text-2xl font-bold text-yellow-400 mb-4">📅 Attendance Report (<?= htmlspecialchars($filter) ?>)</h1>

    <div class="mb-4 space-x-2">
      <a href="?filter=daily" class="px-3 py-1 rounded bg-sky-600 hover:bg-sky-500">Daily</a>
      <a href="?filter=weekly" class="px-3 py-1 rounded bg-sky-600 hover:bg-sky-500">Weekly</a>
      <a href="?filter=monthly" class="px-3 py-1 rounded bg-sky-600 hover:bg-sky-500">Monthly</a>
    </div>

    <table class="w-full table-auto border border-slate-700">
      <thead class="bg-slate-800">
        <tr>
          <th class="p-2 text-left">Student</th>
          <th class="p-2">Class</th>
          <th class="p-2">Date</th>
          <th class="p-2">Status</th>
        </tr>
      </thead>
      <tbody>
        <?php while($row = $result->fetch_assoc()): ?>
        <tr class="border-b border-slate-700">
          <td class="p-2"><?= htmlspecialchars($row['name']) ?></td>
          <td class="p-2 text-center"><?= htmlspecialchars($row['class']) ?></td>
          <td class="p-2 text-center"><?= $row['date'] ?></td>
          <td class="p-2 text-center <?= $row['status'] === 'present' ? 'text-green-400' : 'text-red-400' ?>">
            <?= ucfirst($row['status']) ?>
          </td>
        </tr>
        <?php endwhile; ?>
      </tbody>
    </table>

    <div class="mt-6">
      <a href="dashboard.php" class="text-yellow-300 hover:underline">⬅️ Back to Dashboard</a>
    </div>
  </div>
</body>
</html>
