<?php
session_start();
include "../config.php";

if (isset($_SESSION['admin_email'])) {
  header("Location: dashboard.php");
  exit;
}

$error = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email = $_POST['email'];
  $password = $_POST['password'];

  $stmt = $conn->prepare("SELECT * FROM admin WHERE email = ?");
  $stmt->bind_param("s", $email);
  $stmt->execute();
  $res = $stmt->get_result();
  if ($admin = $res->fetch_assoc()) {
    if (password_verify($password, $admin['password'])) {
      $_SESSION['admin_email'] = $email;
      header("Location: dashboard.php");
      exit;
    } else {
      $error = "Incorrect password.";
    }
  } else {
    $error = "Admin not found.";
  }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Admin Login</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 text-white flex items-center justify-center min-h-screen">
  <div class="w-full max-w-sm p-6 bg-slate-800 rounded-xl">
    <h1 class="text-2xl font-bold text-center text-yellow-400 mb-6">Admin Login</h1>
    <?php if ($error): ?>
      <div class="bg-red-600 text-sm p-3 rounded mb-4"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
    <form method="POST" class="space-y-4">
      <input type="email" name="email" placeholder="Email" required class="w-full px-4 py-2 bg-slate-700 rounded" />
      <input type="password" name="password" placeholder="Password" required class="w-full px-4 py-2 bg-slate-700 rounded" />
      <button type="submit" class="w-full bg-yellow-400 text-black font-bold py-2 rounded hover:bg-yellow-300">Login</button>
    </form>
  </div>
</body>
</html>
