<?php
session_start();
include "config.php";

if (!isset($_SESSION['teacher_email'])) {
  header("Location: login.php");
  exit;
}

$email = $_SESSION['teacher_email'];
$stmt = $conn->prepare("SELECT id, name, api_key FROM teachers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$res = $stmt->get_result();
$teacher = $res->fetch_assoc();
$teacher_id = $teacher['id'];

// Fetch SMS logs
$sms_stmt = $conn->prepare("SELECT number, message, status, sent_at FROM sms_logs WHERE teacher_id = ? ORDER BY sent_at DESC LIMIT 10");
$sms_stmt->bind_param("i", $teacher_id);
$sms_stmt->execute();
$sms_logs = $sms_stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Dashboard</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    function toggleDrawer() {
      document.getElementById("drawer").classList.toggle("-translate-x-full");
    }
  </script>
</head>
<body class="bg-slate-900 text-white min-h-screen">
<div class="flex">
  <!-- Drawer Sidebar -->
  <div id="drawer" class="fixed top-0 left-0 w-64 bg-slate-800 h-full shadow-xl transform -translate-x-full md:translate-x-0 transition-transform duration-300 z-50">
    <div class="p-4 border-b border-slate-700">
      <h2 class="text-xl font-bold text-yellow-400">SM Teacher</h2>
      <p class="text-sm text-slate-400 mt-1">Welcome, <?= htmlspecialchars($teacher['name']) ?></p>
    </div>
    <nav class="p-4 space-y-3 text-sm">
      <a href="dashboard.php" class="block text-slate-200 hover:text-yellow-400">🏠 Dashboard</a>
      <a href="students.php" class="block text-slate-200 hover:text-yellow-400">🎓 Manage Students</a>
      <a href="attendance.php" class="block text-slate-200 hover:text-yellow-400">📋 Mark Attendance</a>
      <a href="attendance-report.php" class="block text-slate-200 hover:text-yellow-400">📅 Attendance Report</a>
      <a href="send-sms.php" class="block text-slate-200 hover:text-yellow-400">📨 Send SMS</a>
      <a href="template-editor.php" class="block text-slate-200 hover:text-yellow-400">📋 Edit SMS Template</a>
      <a href="result-sms.php" class="block text-slate-200 hover:text-yellow-400">📊 Result SMS</a>
      <a href="result-make.php" class="block text-slate-200 hover:text-yellow-400">📜 Result sheet maker</a>
      <a href="view-results.php" class="block text-slate-200 hover:text-yellow-400">📋 Result sheet view</a>
      <a href="sms-scheduler.php" class="block text-slate-200 hover:text-yellow-400">⏰ SMS Scheduler</a>
      <a href="notice-broadcast.php" class="block text-slate-200 hover:text-yellow-400">📢 Notice Broadcast</a>
      <a href="sms-history.php" class="block text-slate-200 hover:text-yellow-400">📜 SMS Logs</a>
      <a href="profile.php" class="block text-slate-200 hover:text-yellow-400">⚙️ Profile</a>
      <a href="logout.php" class="block text-red-400 hover:text-red-300">🚪 Logout</a>
    </nav>
  </div>

  <!-- Main Content -->
  <div class="flex-1 md:ml-64 p-6">
    <button onclick="toggleDrawer()" class="md:hidden bg-yellow-400 text-black font-bold px-4 py-2 rounded mb-4">☰ Menu</button>

    <!-- Teacher Info -->
    <div class="bg-slate-800 p-6 rounded-xl mb-6">
      <h1 class="text-2xl font-bold text-yellow-400 mb-2">🎓 Welcome, <?= htmlspecialchars($teacher['name']) ?></h1>
      <p class="text-sm text-slate-300 mb-1">Email: <?= htmlspecialchars($email) ?></p>
      <p class="text-sm text-slate-300 mb-1">API Key: <code class="bg-slate-700 px-2 py-1 rounded text-yellow-300"><?= htmlspecialchars($teacher['api_key']) ?></code></p>
      <p class="text-sm text-slate-400">Login Time: <?= date("F j, Y, g:i a") ?></p>
    </div>

    <!-- SMS History -->
    <div class="bg-slate-800 p-6 rounded-xl">
      <h2 class="text-xl font-semibold text-yellow-400 mb-4">📜 Latest SMS History</h2>
      <div class="overflow-auto">
        <table class="w-full text-sm text-left border border-slate-700">
          <thead>
            <tr class="bg-slate-700 text-slate-300">
              <th class="py-2 px-4">Number</th>
              <th class="py-2 px-4">Message</th>
              <th class="py-2 px-4">Status</th>
              <th class="py-2 px-4">Sent At</th>
            </tr>
          </thead>
          <tbody>
            <?php while($sms = $sms_logs->fetch_assoc()): ?>
            <tr class="border-t border-slate-700">
              <td class="py-2 px-4 text-slate-300"><?= htmlspecialchars($sms['number']) ?></td>
              <td class="py-2 px-4 text-slate-300"><?= htmlspecialchars($sms['message']) ?></td>
              <td class="py-2 px-4 text-slate-300"><?= htmlspecialchars($sms['status']) ?></td>
              <td class="py-2 px-4 text-slate-400 text-xs"><?= date("d M Y, g:i A", strtotime($sms['sent_at'])) ?></td>
            </tr>
            <?php endwhile; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
</body>
</html>
