<?php
// login.php (Logic at top)
include "config.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email    = trim($_POST['email']);
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT id, name, password FROM teachers WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->bind_result($id, $name, $hashed);
    if ($stmt->fetch() && password_verify($password, $hashed)) {
        $_SESSION['teacher_id'] = $id;
        $_SESSION['teacher_name'] = $name;
        $_SESSION['teacher_email'] = $email;
        header("Location: dashboard.php");
        exit;
    } else {
        $error = "Invalid credentials!";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>SM Teacher Login</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 text-white flex items-center justify-center min-h-screen">
  <div class="w-full max-w-md bg-slate-800 p-8 rounded-xl shadow-xl">
    <h2 class="text-2xl font-bold mb-6 text-center text-yellow-400">👨‍🏫 SM Teacher Login</h2>

    <?php if (isset($error)) echo "<p class='text-red-500 mb-4 text-center'>$error</p>"; ?>
    <?php if (isset($_GET['registered'])) echo "<p class='text-green-500 mb-4 text-center'>✅ Registration successful. Please login.</p>"; ?>

    <form method="POST" class="space-y-4">
      <input type="email" name="email" placeholder="Email address"
        class="w-full px-4 py-3 rounded-lg bg-slate-700 focus:outline-none focus:ring-2 focus:ring-yellow-400" required />

      <input type="password" name="password" placeholder="Password"
        class="w-full px-4 py-3 rounded-lg bg-slate-700 focus:outline-none focus:ring-2 focus:ring-yellow-400" required />

      <button type="submit"
        class="w-full py-3 bg-yellow-400 hover:bg-yellow-300 text-black font-semibold rounded-lg">Login</button>
    </form>

    <p class="mt-6 text-center text-sm text-slate-400">
      Don't have an account? <a href="register.php" class="text-yellow-300 hover:underline">Register</a>
    </p>
  </div>
</body>
</html>
