<?php
session_start();
include "config.php";
require_once 'dompdf/autoload.inc.php';
use Dompdf\Dompdf;
use Dompdf\Options;

if (!isset($_SESSION['teacher_email']) || !isset($_POST['student_id'])) {
  header("Location: result-make.php");
  exit;
}

$teacher_email = $_SESSION['teacher_email'];
$teacher_stmt = $conn->prepare("SELECT id, name, logo FROM teachers WHERE email = ?");
$teacher_stmt->bind_param("s", $teacher_email);
$teacher_stmt->execute();
$teacher_data = $teacher_stmt->get_result()->fetch_assoc();

$teacher_id = $teacher_data['id'];
$teacher_logo = $teacher_data['logo'];

$student_id = intval($_POST['student_id']);
$student = $conn->query("SELECT * FROM students WHERE id = $student_id")->fetch_assoc();

$subjects = $_POST['subject'] ?? [];
$marks = $_POST['mark'] ?? [];

$total_marks = 0;
$total_gpa = 0;
$fail = false;
$subject_rows = '';

function calculate_gpa($mark) {
  if ($mark >= 80) return 5.00;
  if ($mark >= 70) return 4.00;
  if ($mark >= 60) return 3.50;
  if ($mark >= 50) return 3.00;
  if ($mark >= 40) return 2.00;
  if ($mark >= 33) return 1.00;
  return 0.00;
}

foreach ($subjects as $index => $subject) {
  $mark = floatval($marks[$index]);
  $gpa = calculate_gpa($mark);
  if ($gpa == 0.00) $fail = true;

  $subject_rows .= "
    <tr>
      <td style='padding:6px; border:1px solid #ccc;'>".htmlspecialchars($subject)."</td>
      <td style='padding:6px; border:1px solid #ccc;'>$mark</td>
      <td style='padding:6px; border:1px solid #ccc;'>".number_format($gpa, 2)."</td>
    </tr>
  ";

  $total_marks += $mark;
  $total_gpa += $gpa;
}

$avg_gpa = count($subjects) > 0 ? $total_gpa / count($subjects) : 0;
$final_status = $fail ? "<span style='color:red;'>❌ Fail</span>" : "<span style='color:green;'>✅ Pass</span>";
$final_gpa_display = number_format($avg_gpa, 2);

// Full absolute URL for logo (change domain if needed)
$logo_html = '';
if ($teacher_logo && file_exists("uploads/$teacher_logo")) {
  $logo_url = "https://teacher.sm10x.xyz/uploads/$teacher_logo";
  $logo_html = "<img src='$logo_url' style='height:80px; margin-bottom:10px;' />";
}

$html = "
<div style='font-family: DejaVu Sans, sans-serif;'>
  <div style='text-align:center; margin-bottom:20px;'>
    $logo_html
    <h2 style='color:#333;'>Student Result Sheet</h2>
  </div>
  <p><strong>Name:</strong> {$student['name']}</p>
  <p><strong>Class:</strong> {$student['class']}</p>
  <p><strong>Roll:</strong> {$student['roll']}</p>
  <p><strong>Parent Number:</strong> {$student['parent_number']}</p>

  <table width='100%' cellspacing='0' cellpadding='0' style='margin-top:20px; border-collapse: collapse;'>
    <thead style='background:#eee;'>
      <tr>
        <th style='padding:8px; border:1px solid #ccc;'>Subject</th>
        <th style='padding:8px; border:1px solid #ccc;'>Mark</th>
        <th style='padding:8px; border:1px solid #ccc;'>GPA</th>
      </tr>
    </thead>
    <tbody>
      $subject_rows
    </tbody>
  </table>

  <div style='margin-top:20px; font-size:16px;'>
    <p><strong>Total Marks:</strong> ".number_format($total_marks, 2)."</p>
    <p><strong>GPA:</strong> $final_gpa_display</p>
    <p><strong>Status:</strong> $final_status</p>
  </div>
</div>
";

// PDF render
$options = new Options();
$options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

// Save file
if (!is_dir("uploads/results")) {
  mkdir("uploads/results", 0777, true);
}
$filename = "result_" . time() . ".pdf";
$filepath = "uploads/results/" . $filename;
file_put_contents($filepath, $dompdf->output());

// Save to DB
$stmt = $conn->prepare("INSERT INTO result_pdfs (teacher_id, student_id, class, roll, student_name, pdf_link) VALUES (?, ?, ?, ?, ?, ?)");
$stmt->bind_param("iissss", $teacher_id, $student_id, $student['class'], $student['roll'], $student['name'], $filepath);
$stmt->execute();

echo "<script>
  alert('✅ PDF generated successfully!');
  window.location.href = 'view-results.php';
</script>";
?>
