<?php
session_start();
include "config.php";

if (!isset($_SESSION['teacher_email'])) {
  header("Location: login.php");
  exit;
}

$email = $_SESSION['teacher_email'];
$stmt = $conn->prepare("SELECT * FROM teachers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();
$teacher = $result->fetch_assoc();
$teacher_id = $teacher['id'];
$api_key = $teacher['api_key'];
$institute = $teacher['institute_name'] ?? 'null';


// টেমপ্লেট ডাটাবেস থেকে আনুন
$template = "Dear guardian, your child \$name got \$result in \$exam from \$institute.";
$template_row = $conn->query("SELECT template FROM result_sms_template WHERE teacher_id = $teacher_id")->fetch_assoc();
if ($template_row) {
  $template = $template_row['template'];
}

$response = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['results']) && isset($_POST['selected_students'])) {
  $results = $_POST['results'];
  $selected = $_POST['selected_students'];
  $exam = $_POST['exam'] ?? 'Exam';

  foreach ($selected as $sid) {
    $sid = intval($sid);
    $marks = trim($results[$sid]);

    // student তথ্য আনুন
    $student_result = $conn->query("SELECT name, parent_number FROM students WHERE id = $sid");
    if ($student_result && $student_result->num_rows > 0) {
      $s = $student_result->fetch_assoc();
      $name = $s['name'];
      $parent_number = $s['parent_number'];

      // SMS বানান টেমপ্লেট অনুযায়ী
      $tokens = [
  '$name' => $name,
  '$result' => $marks,
  '$exam' => $exam,
  '$institute' => $institute
];

$sms = strtr($template, $tokens);


      if ($api_key && $parent_number) {
        $data = [
          "api" => $api_key,
          "number" => $parent_number,
          "message" => $sms
        ];

        $ch = curl_init("https://panel.sm10x.xyz/sent_sms_post.php");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
        curl_exec($ch);
        curl_close($ch);

        // লগ
        $conn->query("INSERT INTO sms_logs (teacher_id, student_id, number, message, status) VALUES ($teacher_id, $sid, '$parent_number', '".$conn->real_escape_string($sms)."', 'sent')");
      }
    }
  }

  $response = "✅ Result SMS sent successfully.";
}

// student list
$students = $conn->query("SELECT * FROM students WHERE teacher_id = $teacher_id ORDER BY class, roll ASC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Result SMS | SM Teacher</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 text-white min-h-screen">
<div class="max-w-5xl mx-auto p-6">
  <div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-bold text-yellow-400">📢 Send Result SMS</h1>
    <a href="dashboard.php" class="text-sm text-sky-400 hover:underline">← Dashboard</a>
  </div>

  <?php if ($response): ?>
    <div class="mb-4 p-3 rounded text-sm bg-green-600"><?= htmlspecialchars($response) ?></div>
  <?php endif; ?>

  <form method="POST" class="bg-slate-800 p-5 rounded-xl">
    <label class="block mb-2 text-sm">📘 Exam Name:</label>
    <input type="text" name="exam" placeholder="e.g. Final Exam 2025" class="w-full mb-4 p-2 bg-slate-700 rounded" required>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <?php while($row = $students->fetch_assoc()): ?>
        <div class="bg-slate-700 p-3 rounded">
          <label class="flex items-center space-x-2 mb-2">
            <input type="checkbox" name="selected_students[]" value="<?= $row['id'] ?>" class="accent-yellow-400">
            <span><?= htmlspecialchars($row['name']) ?> (<?= htmlspecialchars($row['class']) ?>)</span>
          </label>
          <input type="text" name="results[<?= $row['id'] ?>]" placeholder="e.g. GPA 4.00 or 90/100" class="w-full p-2 bg-slate-800 rounded">
        </div>
      <?php endwhile; ?>
    </div>

    <button type="submit" class="mt-6 w-full bg-yellow-400 text-black font-semibold py-3 rounded hover:bg-yellow-300">📤 Send Result SMS</button>
  </form>
</div>
</body>
</html>