<?php
session_start();
include "config.php";

if (!isset($_SESSION['teacher_email'])) {
  header("Location: login.php");
  exit;
}

$email = $_SESSION['teacher_email'];
$stmt = $conn->prepare("SELECT * FROM teachers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();
$teacher = $result->fetch_assoc();
$teacher_id = $teacher['id'];
$api_key = $teacher['api_key'];

$response = "";

// Filters
$class_filter = $_GET['class'] ?? '';
$name_filter = $_GET['name'] ?? '';

$sql = "SELECT * FROM students WHERE teacher_id = $teacher_id";
if ($class_filter !== '') {
  $class_filter = $conn->real_escape_string($class_filter);
  $sql .= " AND class LIKE '%$class_filter%'";
}
if ($name_filter !== '') {
  $name_filter = $conn->real_escape_string($name_filter);
  $sql .= " AND name LIKE '%$name_filter%'";
}
$sql .= " ORDER BY class ASC, roll ASC";
$students = $conn->query($sql);

// Handle SMS send
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $message = trim($_POST['message']);
  $recipients = $_POST['recipients'] ?? [];

  if (!$api_key) {
    $response = "❌ API Key missing!";
  } elseif (empty($message) || empty($recipients)) {
    $response = "❌ Message and recipients required.";
  } else {
    foreach ($recipients as $number) {
      $data = [
        "api" => $api_key,
        "number" => $number,
        "message" => $message
      ];

      $ch = curl_init("https://panel.sm10x.xyz/sent_sms_post.php");
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_POST, true);
      curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
      curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
      curl_exec($ch);
      curl_close($ch);

      $conn->query("INSERT INTO sms_logs (teacher_id, number, message, status) VALUES ($teacher_id, '$number', '".$conn->real_escape_string($message)."', 'sent')");
    }
    $response = "✅ SMS sent successfully.";
  }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Send SMS | SM Teacher</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    function toggleAll(source) {
      const checkboxes = document.querySelectorAll('input[name="recipients[]"]');
      for (let box of checkboxes) {
        box.checked = source.checked;
      }
    }
  </script>
</head>
<body class="bg-slate-900 text-white min-h-screen">
  <div class="max-w-5xl mx-auto p-6">
    <div class="flex items-center justify-between mb-6">
      <h1 class="text-2xl font-bold text-yellow-400">✉️ Send SMS</h1>
      <a href="dashboard.php" class="text-sm text-sky-400 hover:underline">← Back to Dashboard</a>
    </div>

    <?php if ($response): ?>
      <div class="mb-4 p-3 rounded text-sm <?= strpos($response, '✅') === 0 ? 'bg-green-600' : 'bg-red-600' ?>">
        <?= htmlspecialchars($response) ?>
      </div>
    <?php endif; ?>

    <!-- Filter -->
    <form method="GET" class="mb-4 flex flex-wrap gap-3">
      <input type="text" name="class" value="<?= htmlspecialchars($class_filter) ?>" placeholder="Search by Class" class="px-3 py-2 bg-slate-700 rounded">
      <input type="text" name="name" value="<?= htmlspecialchars($name_filter) ?>" placeholder="Search by Name" class="px-3 py-2 bg-slate-700 rounded">
      <button type="submit" class="bg-yellow-400 text-black px-4 py-2 rounded hover:bg-yellow-300">🔍 Filter</button>
      <a href="send-sms.php" class="text-sky-300 underline text-sm mt-3">Reset</a>
    </form>

    <form method="POST" class="bg-slate-800 p-5 rounded-xl">
      <label class="block mb-2">✍️ Message:</label>
      <textarea name="message" rows="4" required class="w-full p-3 bg-slate-700 rounded"></textarea>

      <label class="block mt-5 mb-2">👥 Recipients:</label>
      <div class="mb-2">
        <label><input type="checkbox" onclick="toggleAll(this)" class="accent-yellow-400 mr-2"> Select All</label>
      </div>

      <div class="grid grid-cols-1 md:grid-cols-2 gap-2 max-h-64 overflow-y-auto">
        <?php while($row = $students->fetch_assoc()): ?>
          <label class="flex items-center space-x-2">
            <input type="checkbox" name="recipients[]" value="<?= htmlspecialchars($row['phone']) ?>" class="accent-yellow-400">
            <span><?= htmlspecialchars($row['name']) ?> (Class: <?= htmlspecialchars($row['class']) ?>, <?= $row['phone'] ?>)</span>
          </label>
        <?php endwhile; ?>
      </div>

      <button type="submit" class="mt-6 w-full bg-yellow-400 text-black font-semibold py-3 rounded hover:bg-yellow-300">🚀 Send SMS</button>
    </form>
  </div>
</body>
</html>
