<?php
// sms-scheduler.php
session_start();
include "config.php";

if (!isset($_SESSION['teacher_email'])) {
  header("Location: login.php");
  exit;
}

$email = $_SESSION['teacher_email'];
$stmt = $conn->prepare("SELECT id, api_key FROM teachers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$res = $stmt->get_result();
$teacher = $res->fetch_assoc();
$teacher_id = $teacher['id'];
$api_key = $teacher['api_key'];

// Fetch students
$students_result = $conn->query("SELECT name, phone, class FROM students WHERE teacher_id = $teacher_id ORDER BY class ASC");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $message = $_POST['message'] ?? '';
  $recipients = $_POST['recipients'] ?? [];
  $schedule_time = $_POST['schedule_time'] ?? '';

  if ($message && !empty($recipients) && $schedule_time) {
    foreach ($recipients as $number) {
      $stmt = $conn->prepare("INSERT INTO scheduled_sms (teacher_id, number, message, schedule_time, status) VALUES (?, ?, ?, ?, 'pending')");
      $stmt->bind_param("isss", $teacher_id, $number, $message, $schedule_time);
      $stmt->execute();
    }
    $success = true;
  } else {
    $error = "All fields are required.";
  }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Schedule SMS</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 text-white p-6">
  <div class="max-w-3xl mx-auto">
    <h1 class="text-2xl font-bold text-yellow-400 mb-4">📆 Schedule SMS</h1>

    <?php if (!empty($success)): ?>
      <div class="bg-green-600 text-white p-3 rounded mb-4">✅ SMS Scheduled Successfully!</div>
    <?php elseif (!empty($error)): ?>
      <div class="bg-red-600 text-white p-3 rounded mb-4">❌ <?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="POST" class="space-y-4">
      <div>
        <label>✉️ Message:</label>
        <textarea name="message" class="w-full p-2 rounded bg-slate-800" required></textarea>
      </div>

      <div>
        <label>⏰ Schedule Time:</label>
        <input type="datetime-local" name="schedule_time" class="w-full p-2 rounded bg-slate-800" required>
      </div>

      <div>
        <label>👥 Select Recipients:</label>
        <input type="text" placeholder="Search..." onkeyup="filterStudents(this.value)" class="w-full p-2 rounded bg-slate-800 mb-2">

        <label class="inline-flex items-center mb-2">
          <input type="checkbox" id="selectAll" onclick="toggleSelectAll(this)" class="mr-2">
          Select All
        </label>

        <div id="studentList" class="max-h-64 overflow-y-auto grid grid-cols-1 md:grid-cols-2 gap-2 p-3 bg-slate-800 rounded">
          <?php while($row = $students_result->fetch_assoc()): ?>
            <label class="flex items-center space-x-2">
              <input type="checkbox" name="recipients[]" value="<?= htmlspecialchars($row['phone']) ?>" class="student-checkbox accent-yellow-400">
              <span><?= htmlspecialchars($row['name']) ?> (<?= htmlspecialchars($row['class']) ?>)</span>
            </label>
          <?php endwhile; ?>
        </div>
      </div>

      <button type="submit" class="w-full bg-yellow-400 text-black font-bold py-2 px-4 rounded hover:bg-yellow-300">🚀 Schedule SMS</button>
    </form>

    <div class="mt-6">
      <a href="dashboard.php" class="text-yellow-300 hover:underline">⬅️ Back to Dashboard</a>
    </div>
  </div>

  <script>
    function toggleSelectAll(source) {
      const checkboxes = document.querySelectorAll('.student-checkbox');
      checkboxes.forEach(cb => cb.checked = source.checked);
    }

    function filterStudents(query) {
      const lower = query.toLowerCase();
      const items = document.querySelectorAll('#studentList label');
      items.forEach(item => {
        const text = item.textContent.toLowerCase();
        item.style.display = text.includes(lower) ? '' : 'none';
      });
    }
  </script>
</body>
</html>
