<?php
// students.php
session_start();
include "config.php";

if (!isset($_SESSION['teacher_email'])) {
  header("Location: login.php");
  exit;
}

$email = $_SESSION['teacher_email'];
$stmt = $conn->prepare("SELECT id FROM teachers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();
$teacher = $result->fetch_assoc();
$teacher_id = $teacher['id'];

// Add Student
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_student'])) {
  $name = trim($_POST['name']);
  $phone = trim($_POST['phone']);
  $class = trim($_POST['class']);
  $roll = trim($_POST['roll']);
  $parent = trim($_POST['parent']);

  $insert = $conn->prepare("INSERT INTO students (teacher_id, name, phone, class, roll, parent_number) VALUES (?, ?, ?, ?, ?, ?)");
  $insert->bind_param("isssss", $teacher_id, $name, $phone, $class, $roll, $parent);
  $insert->execute();
  header("Location: students.php?added=1");
  exit;
}

// Delete Student
if (isset($_GET['delete'])) {
  $id = intval($_GET['delete']);
  $check = $conn->prepare("SELECT * FROM students WHERE id = ? AND teacher_id = ?");
  $check->bind_param("ii", $id, $teacher_id);
  $check->execute();
  $res = $check->get_result();
  if ($res->num_rows > 0) {
    $conn->query("DELETE FROM students WHERE id = $id");
    header("Location: students.php?deleted=1");
    exit;
  }
}

// Update Student
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_student'])) {
  $id = intval($_POST['student_id']);
  $name = $_POST['name'];
  $phone = $_POST['phone'];
  $class = $_POST['class'];
  $roll = $_POST['roll'];
  $parent = $_POST['parent'];

  $update = $conn->prepare("UPDATE students SET name=?, phone=?, class=?, roll=?, parent_number=? WHERE id=? AND teacher_id=?");
  $update->bind_param("ssssssi", $name, $phone, $class, $roll, $parent, $id, $teacher_id);
  $update->execute();
  header("Location: students.php?updated=1");
  exit;
}

$students = $conn->query("SELECT * FROM students WHERE teacher_id = $teacher_id ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Students | SM Teacher</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-900 text-white min-h-screen">
  <div class="max-w-5xl mx-auto p-6">
    <div class="flex items-center justify-between mb-6">
      <h1 class="text-2xl font-bold text-yellow-400">📚 Manage Students</h1>
      <a href="dashboard.php" class="text-sm text-sky-400 hover:underline">← Back</a>
    </div>

    <!-- Add Student -->
    <form method="POST" class="grid grid-cols-1 md:grid-cols-3 gap-4 bg-slate-800 p-4 rounded-xl mb-6">
      <input type="hidden" name="add_student" value="1">
      <input type="text" name="name" placeholder="Student Name" required class="px-3 py-2 rounded bg-slate-700">
      <input type="text" name="phone" placeholder="Phone Number" required class="px-3 py-2 rounded bg-slate-700">
      <input type="text" name="class" placeholder="Class" required class="px-3 py-2 rounded bg-slate-700">
      <input type="text" name="roll" placeholder="Roll" class="px-3 py-2 rounded bg-slate-700">
      <input type="text" name="parent" placeholder="Parent Number" class="px-3 py-2 rounded bg-slate-700">
      <button type="submit" class="bg-yellow-400 text-black font-semibold px-4 py-2 rounded hover:bg-yellow-300">➕ Add</button>
    </form>

    <!-- Edit Modal (hidden by default) -->
    <div id="editModal" class="hidden fixed inset-0 bg-black bg-opacity-60 flex items-center justify-center z-50">
      <form method="POST" class="bg-slate-800 p-6 rounded-lg w-full max-w-md">
        <h2 class="text-xl mb-4 text-yellow-400 font-bold">✏️ Edit Student</h2>
        <input type="hidden" name="edit_student" value="1">
        <input type="hidden" id="edit_id" name="student_id">
        <input type="text" id="edit_name" name="name" placeholder="Name" class="w-full mb-2 px-3 py-2 bg-slate-700 rounded">
        <input type="text" id="edit_phone" name="phone" placeholder="Phone" class="w-full mb-2 px-3 py-2 bg-slate-700 rounded">
        <input type="text" id="edit_class" name="class" placeholder="Class" class="w-full mb-2 px-3 py-2 bg-slate-700 rounded">
        <input type="text" id="edit_roll" name="roll" placeholder="Roll" class="w-full mb-2 px-3 py-2 bg-slate-700 rounded">
        <input type="text" id="edit_parent" name="parent" placeholder="Parent Number" class="w-full mb-4 px-3 py-2 bg-slate-700 rounded">
        <div class="flex justify-between">
          <button type="button" onclick="closeModal()" class="text-red-400 hover:underline">Cancel</button>
          <button type="submit" class="bg-yellow-400 px-4 py-2 text-black font-bold rounded hover:bg-yellow-300">✅ Update</button>
        </div>
      </form>
    </div>

    <!-- Student Table -->
    <div class="bg-slate-800 p-4 rounded-xl overflow-auto">
      <table class="w-full text-sm text-left">
        <thead class="text-yellow-300 border-b border-slate-600">
          <tr>
            <th class="py-2 px-2">Name</th>
            <th class="py-2 px-2">Phone</th>
            <th class="py-2 px-2">Class</th>
            <th class="py-2 px-2">Roll</th>
            <th class="py-2 px-2">Parent</th>
            <th class="py-2 px-2">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php while($row = $students->fetch_assoc()): ?>
          <tr class="border-b border-slate-700 hover:bg-slate-700">
            <td class="py-2 px-2"><?= htmlspecialchars($row['name']) ?></td>
            <td class="py-2 px-2"><?= htmlspecialchars($row['phone']) ?></td>
            <td class="py-2 px-2"><?= htmlspecialchars($row['class']) ?></td>
            <td class="py-2 px-2"><?= htmlspecialchars($row['roll']) ?></td>
            <td class="py-2 px-2"><?= htmlspecialchars($row['parent_number']) ?></td>
            <td class="py-2 px-2 flex gap-2">
              <button onclick="editStudent(<?= $row['id'] ?>, '<?= $row['name'] ?>', '<?= $row['phone'] ?>', '<?= $row['class'] ?>', '<?= $row['roll'] ?>', '<?= $row['parent_number'] ?>')" class="text-green-400 hover:underline">Edit</button>
              <a href="?delete=<?= $row['id'] ?>" onclick="return confirm('Delete this student?')" class="text-red-400 hover:underline">Delete</a>
            </td>
          </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>

  <script>
    function editStudent(id, name, phone, cls, roll, parent) {
      document.getElementById('edit_id').value = id;
      document.getElementById('edit_name').value = name;
      document.getElementById('edit_phone').value = phone;
      document.getElementById('edit_class').value = cls;
      document.getElementById('edit_roll').value = roll;
      document.getElementById('edit_parent').value = parent;
      document.getElementById('editModal').classList.remove("hidden");
    }
    function closeModal() {
      document.getElementById('editModal').classList.add("hidden");
    }
  </script>
</body>
</html>
